/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IPortalCapability;
import thebetweenlands.client.audio.PortalSound;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.WorldShader;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.structure.BlockTreePortal;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.teleporter.TeleporterHandler;

public class PlayerPortalHandler {
    public static final int MAX_PORTAL_TIME = 120;

    @SubscribeEvent
    public static void teleportCheck(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && (player = (EntityPlayer)entity).hasCapability(CapabilityRegistry.CAPABILITY_PORTAL, null)) {
            IPortalCapability cap = (IPortalCapability)player.getCapability(CapabilityRegistry.CAPABILITY_PORTAL, null);
            if (cap.isInPortal()) {
                AxisAlignedBB aabb;
                BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v);
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                boolean inPortalBlock = false;
                if (state.func_177230_c() instanceof BlockTreePortal && (aabb = state.func_185900_c((IBlockAccess)player.field_70170_p, pos)) != null && aabb.func_186670_a(pos).func_72326_a(player.func_174813_aQ())) {
                    inPortalBlock = true;
                }
                if (inPortalBlock) {
                    if (!cap.wasTeleported()) {
                        if (cap.getTicksUntilTeleport() <= 0 || player.field_71075_bZ.field_75098_d) {
                            if (player.field_71093_bK == 0) {
                                player.field_71088_bW = 10;
                                cap.setWasTeleported(true);
                                TeleporterHandler.transferToBL((Entity)player);
                            } else {
                                player.field_71088_bW = 10;
                                cap.setWasTeleported(true);
                                TeleporterHandler.transferToOverworld((Entity)player);
                            }
                            cap.setInPortal(false);
                            cap.setTicksUntilTeleport(120);
                        } else {
                            cap.setTicksUntilTeleport(cap.getTicksUntilTeleport() - 1);
                        }
                    }
                } else {
                    cap.setTicksUntilTeleport(120);
                    cap.setInPortal(false);
                    cap.setWasTeleported(false);
                }
            } else {
                cap.setTicksUntilTeleport(120);
                if (!cap.isInPortal()) {
                    cap.setWasTeleported(false);
                }
            }
        }
        if (entity.field_70170_p.field_72995_K && entity == TheBetweenlands.proxy.getClientPlayer()) {
            PlayerPortalHandler.updateClientPortal();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void updateClientPortal() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.hasCapability(CapabilityRegistry.CAPABILITY_PORTAL, null)) {
            int timer;
            boolean renderPortalEffect;
            IPortalCapability cap = (IPortalCapability)player.getCapability(CapabilityRegistry.CAPABILITY_PORTAL, null);
            boolean bl = renderPortalEffect = cap.isInPortal() && !cap.wasTeleported();
            if (renderPortalEffect && (timer = cap.getTicksUntilTeleport()) < 120) {
                player.func_71053_j();
                if (timer == 119) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PortalSound(SoundRegistry.PORTAL_TRIGGER, SoundCategory.BLOCKS, (EntityPlayer)player));
                }
                if (timer == 2) {
                    player.func_184185_a((SoundEvent)SoundRegistry.PORTAL_TRAVEL, 1.0f, 0.8f);
                }
            }
            if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
                WorldShader shader = ShaderHelper.INSTANCE.getWorldShader();
                if (!renderPortalEffect) {
                    shader.setSwirlAngle(0.0f);
                } else {
                    float swirl = shader.getSwirlAngle(1.0f);
                    if (swirl < 2.0f) {
                        shader.setSwirlAngle(swirl + swirl * 0.055f + 5.0E-4f);
                    } else {
                        shader.setSwirlAngle(swirl + swirl * 0.055f / (swirl - 1.0f) + 5.0E-4f);
                    }
                }
            }
        }
    }
}

