/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.item.IDecayFood;
import thebetweenlands.common.capability.decay.DecayStats;
import thebetweenlands.common.registries.CapabilityRegistry;

public class PlayerDecayHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            if (!player.field_70170_p.field_72995_K && player.hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) {
                boolean requiresHealthReset;
                IDecayCapability capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
                float currentMaxHealth = (float)player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
                float decayMaxHealth = (int)(capability.getMaxPlayerHealth() / 2.0f) * 2;
                DecayStats stats = capability.getDecayStats();
                boolean bl = capability.isDecayEnabled() ? stats.getDecayLevel() != stats.getPrevDecayLevel() && currentMaxHealth < 20.0f && decayMaxHealth >= 20.0f : (requiresHealthReset = currentMaxHealth < 20.0f);
                if (!capability.isDecayEnabled()) {
                    if (requiresHealthReset) {
                        player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
                    }
                } else {
                    int decay;
                    if (decayMaxHealth < 20.0f || requiresHealthReset) {
                        player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)decayMaxHealth);
                        if (player.func_110143_aJ() > decayMaxHealth) {
                            player.func_70606_j(decayMaxHealth);
                        }
                    }
                    if ((decay = stats.getDecayLevel()) >= 16) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1, 2, true, false));
                        player.field_70747_aH = 0.001f;
                    } else if (decay >= 13) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1, 1, true, false));
                        player.field_70747_aH = 0.002f;
                    } else if (decay >= 10) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1, 0, true, false));
                    }
                    if (!event.player.func_184218_aH()) {
                        EnumDifficulty difficulty = player.field_70170_p.func_175659_aa();
                        float decaySpeed = 0.0f;
                        switch (difficulty) {
                            case PEACEFUL: {
                                decaySpeed = 0.0f;
                                break;
                            }
                            case EASY: {
                                decaySpeed = 0.0025f;
                                break;
                            }
                            case NORMAL: {
                                decaySpeed = 0.0033f;
                                break;
                            }
                            case HARD: {
                                decaySpeed = 0.005f;
                            }
                        }
                        if (player.func_70090_H()) {
                            decaySpeed *= 2.75f;
                        }
                        if (decaySpeed > 0.0f) {
                            stats.addDecayAcceleration(decaySpeed);
                        }
                    }
                    capability.getDecayStats().onUpdate(player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onUseItem(LivingEntityUseItemEvent.Finish event) {
        EntityPlayer player;
        if (event.getItem() != null && event.getItem().func_77973_b() instanceof IDecayFood && event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) {
            IDecayCapability capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
            IDecayFood food = (IDecayFood)event.getItem().func_77973_b();
            capability.getDecayStats().addStats(-food.getDecayHealAmount(event.getItem()), food.getDecayHealSaturation(event.getItem()));
        }
    }

    @SubscribeEvent
    public static void onStartUsingItem(LivingEntityUseItemEvent.Start event) {
        if (event.getItem() != null && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            boolean isDecayFood = event.getItem().func_77973_b() instanceof IDecayFood;
            if (isDecayFood) {
                boolean canEatFood = player.func_71024_bL().func_75121_c() && event.getItem().func_77973_b() instanceof ItemFood && ((ItemFood)event.getItem().func_77973_b()).func_150905_g(event.getItem()) > 0;
                boolean canEatDecayFood = false;
                if (player.hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) {
                    IDecayCapability capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
                    boolean bl = canEatDecayFood = capability.getDecayStats().getDecayLevel() > 0;
                }
                if (!canEatFood && !canEatDecayFood) {
                    event.setDuration(-1);
                    event.setCanceled(true);
                }
            }
        }
    }
}

