/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.common.block.misc.BlockDampTorch;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.config.ConfigHandler;

public class OverworldItemHandler {
    public static final Set<Item> WHITELIST = new HashSet<Item>();

    private OverworldItemHandler() {
    }

    @SubscribeEvent
    public static void onPlayerTorchPlacement(BlockEvent.PlaceEvent event) {
        boolean isHoldingTorchOffhand;
        ItemStack mainHand = event.getPlayer().func_184614_ca();
        ItemStack offHand = event.getPlayer().func_184614_ca();
        boolean isHoldingTorchMainhand = mainHand != null && Block.func_149634_a((Item)mainHand.func_77973_b()) instanceof BlockTorch && !BlockRegistry.BLOCKS.contains(Block.func_149634_a((Item)mainHand.func_77973_b())) && !WHITELIST.contains(mainHand.func_77973_b());
        boolean bl = isHoldingTorchOffhand = offHand != null && Block.func_149634_a((Item)offHand.func_77973_b()) instanceof BlockTorch && !BlockRegistry.BLOCKS.contains(Block.func_149634_a((Item)offHand.func_77973_b())) && !WHITELIST.contains(offHand.func_77973_b());
        if ((isHoldingTorchMainhand || isHoldingTorchOffhand) && event.getPlayer().field_71093_bK == ConfigHandler.dimensionId) {
            for (int x = -2; x <= 2; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        IBlockState block = event.getWorld().func_180495_p(event.getPos().func_177982_a(x, y, z));
                        if (block.func_177230_c() != Blocks.field_150478_aa || BlockRegistry.BLOCKS.contains(block.func_177230_c()) || WHITELIST.contains(Item.func_150898_a((Block)block.func_177230_c()))) continue;
                        EnumFacing facing = (EnumFacing)block.func_177229_b((IProperty)BlockTorch.field_176596_a);
                        IBlockState dampTorch = BlockRegistry.DAMP_TORCH.func_176223_P().func_177226_a((IProperty)BlockDampTorch.field_176596_a, (Comparable)facing);
                        event.getWorld().func_175656_a(event.getPos().func_177982_a(x, y, z), dampTorch);
                        event.getWorld().func_184148_a(null, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.2f, 1.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onUseItem(PlayerInteractEvent.RightClickBlock event) {
        ItemStack item = event.getItemStack();
        if (item != null && event.getEntityPlayer().field_71093_bK == ConfigHandler.dimensionId && item.func_77973_b() instanceof ItemFlintAndSteel && !WHITELIST.contains(item.func_77973_b())) {
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
            if (event.getWorld().field_72995_K) {
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("chat.flintandsteel", new Object[]{new TextComponentTranslation(item.func_77977_a() + ".name", new Object[0])}));
            }
        }
    }

    @SubscribeEvent
    public static void onBonemeal(BonemealEvent event) {
        if (event.getEntityPlayer().field_71093_bK == ConfigHandler.dimensionId) {
            ItemStack mainHand = event.getEntityPlayer().func_184614_ca();
            ItemStack offHand = event.getEntityPlayer().func_184592_cb();
            if (mainHand != null && mainHand.func_77973_b() == Items.field_151100_aR && !WHITELIST.contains(mainHand.func_77973_b())) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
            if (offHand != null && offHand.func_77973_b() == Items.field_151100_aR && !WHITELIST.contains(mainHand.func_77973_b())) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !((EntityPlayer)event.getEntity()).field_71075_bZ.field_75098_d) {
            OverworldItemHandler.updatePlayerInventory((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player.field_70173_aa % 5 == 0 && !event.player.field_71075_bZ.field_75098_d) {
            OverworldItemHandler.updatePlayerInventory(event.player);
        }
    }

    private static void updatePlayerInventory(EntityPlayer player) {
        int invCount = player.field_71071_by.func_70302_i_();
        if (player.field_71093_bK == ConfigHandler.dimensionId) {
            for (int i = 0; i < invCount; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null) continue;
                if (OverworldItemHandler.isRotting(stack)) {
                    ItemStack rottenFoodStack = new ItemStack((Item)ItemRegistry.ROTTEN_FOOD, stack.field_77994_a);
                    stack.field_77994_a = 1;
                    ItemRegistry.ROTTEN_FOOD.setOriginalStack(rottenFoodStack, stack);
                    player.field_71071_by.func_70299_a(i, rottenFoodStack);
                    continue;
                }
                if (!OverworldItemHandler.isTainting(stack)) continue;
                ItemStack taintedPotionStack = new ItemStack((Item)ItemRegistry.TAINTED_POTION, stack.field_77994_a);
                stack.field_77994_a = 1;
                ItemRegistry.TAINTED_POTION.setOriginalStack(taintedPotionStack, stack);
                player.field_71071_by.func_70299_a(i, taintedPotionStack);
            }
        } else {
            for (int i = 0; i < invCount; ++i) {
                ItemStack originalStack;
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null) continue;
                if (stack.func_77973_b() == ItemRegistry.ROTTEN_FOOD) {
                    originalStack = ItemRegistry.ROTTEN_FOOD.getOriginalStack(stack);
                    if (originalStack != null) {
                        originalStack.field_77994_a = stack.field_77994_a;
                        player.field_71071_by.func_70299_a(i, originalStack);
                        continue;
                    }
                    player.field_71071_by.func_70299_a(i, null);
                    continue;
                }
                if (stack.func_77973_b() != ItemRegistry.TAINTED_POTION) continue;
                originalStack = ItemRegistry.TAINTED_POTION.getOriginalStack(stack);
                if (originalStack != null) {
                    originalStack.field_77994_a = stack.field_77994_a;
                    player.field_71071_by.func_70299_a(i, originalStack);
                    continue;
                }
                player.field_71071_by.func_70299_a(i, null);
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack;
        EntityPlayer player = event.getEntityPlayer();
        if (player != null && !player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d && (stack = event.getItem().func_92059_d()) != null) {
            if (player.field_71093_bK == ConfigHandler.dimensionId) {
                if (OverworldItemHandler.isRotting(stack)) {
                    ItemStack rottenFoodStack = new ItemStack((Item)ItemRegistry.ROTTEN_FOOD, stack.field_77994_a);
                    ItemRegistry.ROTTEN_FOOD.setOriginalStack(rottenFoodStack, stack);
                    event.getItem().func_92058_a(rottenFoodStack);
                } else if (OverworldItemHandler.isTainting(stack)) {
                    ItemStack taintedPotionStack = new ItemStack((Item)ItemRegistry.TAINTED_POTION, stack.field_77994_a);
                    ItemRegistry.TAINTED_POTION.setOriginalStack(taintedPotionStack, stack);
                    event.getItem().func_92058_a(taintedPotionStack);
                }
            } else if (stack.func_77973_b() == ItemRegistry.ROTTEN_FOOD) {
                ItemStack originalStack = ItemRegistry.ROTTEN_FOOD.getOriginalStack(stack);
                if (originalStack != null) {
                    event.getItem().func_92058_a(originalStack);
                } else {
                    event.getItem().func_70106_y();
                    event.setCanceled(true);
                }
            } else if (stack.func_77973_b() == ItemRegistry.TAINTED_POTION) {
                ItemStack originalStack = ItemRegistry.TAINTED_POTION.getOriginalStack(stack);
                if (originalStack != null) {
                    event.getItem().func_92058_a(originalStack);
                } else {
                    event.getItem().func_70106_y();
                    event.setCanceled(true);
                }
            }
        }
    }

    public static boolean isRotting(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFood && !WHITELIST.contains(stack.func_77973_b());
    }

    public static boolean isTainting(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemPotion && !WHITELIST.contains(stack.func_77973_b());
    }

    static {
        WHITELIST.add(Items.field_151078_bh);
        WHITELIST.addAll(ItemRegistry.ITEMS);
    }
}

