/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.location.LocationCragrockTower;
import thebetweenlands.common.world.storage.world.shared.location.LocationStorage;

public class LocationHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) != null && !player.func_184812_l_() && !player.field_70170_p.field_72995_K) {
            BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(player.field_70170_p);
            List<LocationCragrockTower> locations = worldStorage.getSharedStorageAt(LocationCragrockTower.class, location -> location.isInside((Entity)player), player.field_70165_t, player.field_70161_v);
            for (LocationCragrockTower location2 : locations) {
                BlockPos structurePos = location2.getStructurePos();
                if (!location2.wasEntered()) {
                    location2.setEntered(true);
                }
                if (location2.getInnerBoundingBox().func_72318_a(player.func_174791_d()) && player.field_70163_u - (double)structurePos.func_177956_o() >= 45.0) {
                    if (location2.isTopReached()) continue;
                    location2.setTopReached(true);
                    continue;
                }
                if (!location2.isTopReached() && !location2.getInnerBoundingBox().func_72314_b(0.5, 0.5, 0.5).func_72318_a(player.func_174791_d()) && player.field_70163_u - (double)structurePos.func_177956_o() > 12.0) {
                    player.func_184210_p();
                    if (player instanceof EntityPlayerMP) {
                        EntityPlayerMP playerMP = (EntityPlayerMP)player;
                        playerMP.field_71135_a.func_147364_a((double)structurePos.func_177958_n() + 0.5, (double)structurePos.func_177956_o(), (double)structurePos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
                    } else {
                        player.func_70012_b((double)structurePos.func_177958_n() + 0.5, (double)structurePos.func_177956_o(), (double)structurePos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
                    }
                    player.field_70143_R = 0.0f;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 2));
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.FORTRESS_BOSS_TELEPORT, SoundCategory.AMBIENT, 1.0f, 1.0f);
                    continue;
                }
                if (!location2.isTopReached() || !(player.field_70163_u - (double)structurePos.func_177956_o() <= 42.0) || location2.isCrumbling() || location2.getCrumblingTicks() != 0) continue;
                location2.setCrumbling(true);
                location2.restoreBlockade(4);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player != null && !event.getWorld().field_72995_K) {
            BlockPos pos = event.getPos();
            IBlockState blockState = event.getState();
            if (blockState.func_177230_c() == BlockRegistry.MOB_SPAWNER) {
                BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(event.getWorld());
                List<LocationCragrockTower> towers = worldStorage.getSharedStorageAt(LocationCragrockTower.class, location -> location.isInside((Vec3i)pos), pos.func_177958_n(), pos.func_177952_p());
                for (LocationCragrockTower tower : towers) {
                    int level = tower.getLevel(pos.func_177956_o());
                    if (level == -1) continue;
                    tower.setSpawnerState(level, false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        if (!player.func_184812_l_()) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            if (event instanceof BlockEvent.MultiPlaceEvent) {
                BlockEvent.MultiPlaceEvent multiPlaceEvent = (BlockEvent.MultiPlaceEvent)event;
                for (BlockSnapshot snapshot : multiPlaceEvent.getReplacedBlockSnapshots()) {
                    positions.add(snapshot.getPos());
                }
            } else {
                positions.add(event.getPos());
            }
            for (BlockPos pos : positions) {
                List<LocationStorage> locations = LocationStorage.getLocations(player.field_70170_p, new Vec3d((Vec3i)pos));
                for (LocationStorage location : locations) {
                    if (location == null || location.getGuard() == null || !location.getGuard().isGuarded(player.field_70170_p, (Entity)player, pos)) continue;
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_184812_l_() && event.getItemStack() != null && Block.func_149634_a((Item)event.getItemStack().func_77973_b()) != null) {
            BlockPos resultingPos = event.getPos();
            IBlockState blockState = player.field_70170_p.func_180495_p(resultingPos);
            if (!blockState.func_177230_c().func_176200_f((IBlockAccess)player.field_70170_p, resultingPos)) {
                resultingPos = resultingPos.func_177972_a(event.getFace());
            }
            List<LocationStorage> locations = LocationStorage.getLocations(player.field_70170_p, new Vec3d((Vec3i)resultingPos));
            for (LocationStorage location : locations) {
                if (location == null || location.getGuard() == null || !location.getGuard().isGuarded(player.field_70170_p, (Entity)player, resultingPos)) continue;
                event.setUseItem(Event.Result.DENY);
                if (event.getWorld().field_72995_K) {
                    Vec3d hitVec = event.getHitVec();
                    BLParticles.BLOCK_PROTECTION.spawn(event.getWorld(), hitVec.field_72450_a + (double)((float)event.getFace().func_82601_c() * 0.025f), hitVec.field_72448_b + (double)((float)event.getFace().func_96559_d() * 0.025f), hitVec.field_72449_c + (double)((float)event.getFace().func_82599_e() * 0.025f), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(event.getFace()));
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        List<LocationStorage> locations = LocationStorage.getLocations(player.field_70170_p, new Vec3d((Vec3i)event.getPos()));
        for (LocationStorage location : locations) {
            if (location == null || location.getGuard() == null || !location.getGuard().isGuarded(player.field_70170_p, (Entity)player, event.getPos())) continue;
            event.setNewSpeed(0.0f);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        World world = event.getWorld();
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(world);
        Long2ObjectOpenHashMap locationCache = new Long2ObjectOpenHashMap();
        ArrayList<LocationStorage> affectedLocations = new ArrayList<LocationStorage>();
        for (BlockPos pos : explosion.func_180343_e()) {
            long chunkId = ChunkPos.func_77272_a((int)(pos.func_177958_n() / 16), (int)(pos.func_177952_p() / 16));
            List<LocationStorage> locations = (List<LocationStorage>)locationCache.get(chunkId);
            if (locations == null) {
                locations = worldStorage.getSharedStorageAt(LocationStorage.class, storage -> storage.getGuard() != null, pos.func_177958_n(), pos.func_177952_p());
                locationCache.put(chunkId, locations);
            }
            for (LocationStorage location : locations) {
                if (!location.getGuard().isGuarded(world, (Entity)explosion.func_94613_c(), pos) || affectedLocations.contains(location)) continue;
                affectedLocations.add(location);
            }
        }
        for (LocationStorage location : affectedLocations) {
            location.getGuard().handleExplosion(world, explosion);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getEntityPlayer().func_184812_l_()) {
            List<LocationStorage> locations = LocationStorage.getLocations(event.getWorld(), new Vec3d((Vec3i)event.getPos()));
            for (LocationStorage location : locations) {
                if (location == null || location.getGuard() == null || !location.getGuard().isGuarded(event.getWorld(), (Entity)event.getEntityPlayer(), event.getPos())) continue;
                if (event.getWorld().field_72995_K && event.getEntityPlayer().field_110158_av == 0) {
                    Vec3d hitVec = event.getHitVec();
                    BLParticles.BLOCK_PROTECTION.spawn(event.getWorld(), hitVec.field_72450_a + (double)((float)event.getFace().func_82601_c() * 0.025f), hitVec.field_72448_b + (double)((float)event.getFace().func_96559_d() * 0.025f), hitVec.field_72449_c + (double)((float)event.getFace().func_82599_e() * 0.025f), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(event.getFace()));
                }
                event.setCanceled(true);
                break;
            }
        }
    }
}

