/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.capability.IFoodSicknessCapability;
import thebetweenlands.api.item.IDecayFood;
import thebetweenlands.api.item.IFoodSicknessItem;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.decay.DecayStats;
import thebetweenlands.common.capability.foodsickness.FoodSickness;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.util.config.ConfigHandler;

public class FoodSicknessHandler {
    private static EnumHand lastHand = EnumHand.MAIN_HAND;
    private static ItemStack lastUsedItem = null;

    private FoodSicknessHandler() {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (!(player == null || lastUsedItem == null || player.func_184586_b(lastHand) != null && player.func_184586_b(lastHand).func_77969_a(lastUsedItem))) {
            lastUsedItem = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void addSicknessMessage(EntityPlayer player, ItemStack item, FoodSickness sickness) {
        if (lastUsedItem == null || !item.func_77969_a(lastUsedItem)) {
            player.func_146105_b((ITextComponent)new TextComponentString(String.format(sickness.getRandomLine(player.func_70681_au()), item.func_82833_r())));
        }
        lastUsedItem = item;
    }

    @SubscribeEvent
    public static void onStartItemUse(LivingEntityUseItemEvent.Start event) {
        EntityPlayer player = event.getEntity() instanceof EntityPlayer ? (EntityPlayer)event.getEntity() : null;
        ItemStack itemStack = event.getItem();
        if (player != null && player.field_71093_bK == ConfigHandler.dimensionId && itemStack != null && itemStack.func_77973_b() instanceof IFoodSicknessItem && ((IFoodSicknessItem)itemStack.func_77973_b()).canGetSickOf(itemStack) && player.hasCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null)) {
            IFoodSicknessCapability cap = (IFoodSicknessCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null);
            ItemFood food = (ItemFood)itemStack.func_77973_b();
            FoodSickness sickness = cap.getSickness(food);
            if (player.field_70170_p.field_72995_K && sickness == FoodSickness.SICK) {
                FoodSicknessHandler.addSicknessMessage(player, itemStack, sickness);
            }
        }
    }

    @SubscribeEvent
    public static void onFinishItemUse(LivingEntityUseItemEvent.Finish event) {
        EntityPlayer player = event.getEntity() instanceof EntityPlayer ? (EntityPlayer)event.getEntity() : null;
        ItemStack itemStack = event.getItem();
        if (player != null && player.field_71093_bK == ConfigHandler.dimensionId && itemStack != null && itemStack.func_77973_b() instanceof IFoodSicknessItem && ((IFoodSicknessItem)itemStack.func_77973_b()).canGetSickOf(itemStack) && player.hasCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null)) {
            IFoodSicknessCapability cap = (IFoodSicknessCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null);
            ItemFood food = (ItemFood)itemStack.func_77973_b();
            if (player.field_70170_p.field_72995_K && cap.getLastSickness() == FoodSickness.SICK) {
                FoodSicknessHandler.addSicknessMessage(player, itemStack, cap.getSickness(food));
            }
            int prevFoodHatred = cap.getFoodHatred(food);
            FoodSickness currentSickness = cap.getSickness(food);
            if (currentSickness == FoodSickness.SICK) {
                int foodLevel = ((ItemFood)itemStack.func_77973_b()).func_150905_g(itemStack);
                double foodLoss = 0.6666666666666666;
                if (player.field_70170_p.field_72995_K) {
                    player.func_71024_bL().func_75122_a(-Math.min(MathHelper.func_76143_f((double)((double)foodLevel * foodLoss)), foodLevel), 0.0f);
                } else {
                    int minFoodGain = player.field_70170_p.field_73012_v.nextInt(4) == 0 ? 1 : 0;
                    player.func_71024_bL().func_75122_a(-Math.min(MathHelper.func_76143_f((double)((double)foodLevel * foodLoss)), Math.max(foodLevel - minFoodGain, 0)), 0.0f);
                }
                if (itemStack.func_77973_b() instanceof IDecayFood && player.hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) {
                    IDecayCapability decayCap = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
                    int decayLevel = ((IDecayFood)itemStack.func_77973_b()).getDecayHealAmount(itemStack);
                    DecayStats decayStats = decayCap.getDecayStats();
                    double decayLoss = 0.6666666666666666;
                    if (player.field_70170_p.field_72995_K) {
                        decayStats.addStats(-Math.min(MathHelper.func_76143_f((double)((double)decayLevel * decayLoss)), decayLevel), 0.0f);
                    } else {
                        int minDecayGain = player.field_70170_p.field_73012_v.nextInt(4) == 0 ? 1 : 0;
                        decayStats.addStats(-Math.min(MathHelper.func_76143_f((double)((double)decayLevel * decayLoss)), Math.max(decayLevel - minDecayGain, 0)), 0.0f);
                    }
                }
                if (!player.field_70170_p.field_72995_K) {
                    cap.increaseFoodHatred(food, 5, 0);
                }
            } else if (!player.field_70170_p.field_72995_K) {
                cap.increaseFoodHatred(food, 5, prevFoodHatred <= 10 ? 4 : 3);
            }
        }
    }
}

