/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.clientbound.MessageSyncEnvironmentEvent;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.EnvironmentEvent;
import thebetweenlands.common.world.event.EnvironmentEventRegistry;
import thebetweenlands.util.config.ConfigHandler;

public class EnvironmentEventHandler {
    private static int lastSync = 0;

    private EnvironmentEventHandler() {
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_73011_w instanceof WorldProviderBetweenlands && !event.getWorld().field_72995_K) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)event.getWorld().field_73011_w;
            provider.getWorldData();
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.world.field_73011_w instanceof WorldProviderBetweenlands && !event.world.field_72995_K) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)event.world.field_73011_w;
            provider.getWorldData().func_76185_a();
            EnvironmentEventRegistry reg = provider.getWorldData().getEnvironmentEventRegistry();
            for (EnvironmentEvent eevent : reg.getEvents().values()) {
                if (!eevent.isLoaded()) continue;
                if (reg.isDisabled()) {
                    eevent.setActive(false, eevent.isActive());
                    eevent.setDefaults();
                } else {
                    eevent.update(event.world);
                }
                if (!eevent.isDirty()) continue;
                eevent.setDirty(false);
                TheBetweenlands.networkWrapper.sendToDimension((IMessage)new MessageSyncEnvironmentEvent(eevent), ConfigHandler.dimensionId);
            }
            if (++lastSync >= 80) {
                lastSync = 0;
                for (EnvironmentEvent eevent : provider.getWorldData().getEnvironmentEventRegistry().getEvents().values()) {
                    TheBetweenlands.networkWrapper.sendToDimension((IMessage)new MessageSyncEnvironmentEvent(eevent), ConfigHandler.dimensionId);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        WorldClient world;
        if (event.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().func_147113_T() && (world = Minecraft.func_71410_x().field_71441_e) != null && world.field_72995_K && world.field_73011_w instanceof WorldProviderBetweenlands) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)world.field_73011_w;
            EnvironmentEventRegistry reg = provider.getWorldData().getEnvironmentEventRegistry();
            for (EnvironmentEvent eevent : reg.getEvents().values()) {
                if (!eevent.isLoaded()) continue;
                eevent.update((World)world);
            }
        }
    }

    @SubscribeEvent
    public static void joinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerMP && event.getWorld().field_73011_w instanceof WorldProviderBetweenlands) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)event.getWorld().field_73011_w;
            for (EnvironmentEvent eevent : provider.getWorldData().getEnvironmentEventRegistry().getEvents().values()) {
                TheBetweenlands.networkWrapper.sendTo((IMessage)new MessageSyncEnvironmentEvent(eevent), (EntityPlayerMP)event.getEntity());
            }
        }
    }
}

