/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.common.entity.mobs.EntityPyrad;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.location.EnumLocationType;
import thebetweenlands.common.world.storage.world.shared.location.LocationStorage;

public class BlockBreakHandler {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player != null && !player.func_184812_l_() && !event.getWorld().field_72995_K) {
            BlockPos pos = event.getPos();
            IBlockState blockState = event.getState();
            if (blockState.func_177230_c() == BlockRegistry.WEEDWOOD || blockState.func_177230_c() == BlockRegistry.LOG_WEEDWOOD) {
                BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(event.getWorld());
                List<LocationStorage> locations = worldStorage.getSharedStorageAt(LocationStorage.class, location -> location.isInside((Vec3i)pos), pos.func_177958_n(), pos.func_177952_p());
                for (LocationStorage location2 : locations) {
                    if (location2.getType() != EnumLocationType.GIANT_TREE) continue;
                    List pyrads = event.getWorld().func_175647_a(EntityPyrad.class, location2.getEnclosingBounds(), pyrad -> location2.isInside((Entity)pyrad));
                    for (EntityPyrad pyrad2 : pyrads) {
                        if (pyrad2.isActive() || event.getWorld().field_73012_v.nextInt(10) != 0) continue;
                        pyrad2.func_184185_a(SoundRegistry.PYRAD_HURT, 0.4f, 1.0f);
                        pyrad2.func_184185_a(SoundRegistry.PYRAD_HURT, 0.4f, 0.5f);
                        pyrad2.func_184185_a(SoundRegistry.PYRAD_HURT, 0.4f, 0.25f);
                        pyrad2.setActive(true);
                        pyrad2.func_70624_b((EntityLivingBase)player);
                    }
                }
            }
        }
    }
}

