/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.handler.OverworldItemHandler;
import thebetweenlands.common.item.tools.ItemBLAxe;
import thebetweenlands.common.item.tools.ItemBLPickaxe;
import thebetweenlands.common.item.tools.ItemBLShovel;
import thebetweenlands.common.item.tools.ItemBLSword;
import thebetweenlands.common.network.clientbound.MessagePowerRingParticles;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class AttackDamageHandler {
    public static final float DAMAGE_REDUCTION = 0.3f;

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        EntityLivingBase attacker;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        if (attackedEntity instanceof IEntityBL && source.func_76364_f() instanceof EntityPlayer) {
            damage = Math.min(damage, 40.0f);
            EntityPlayer entityPlayer = (EntityPlayer)source.func_76364_f();
            ItemStack heldItem = entityPlayer.func_184586_b(entityPlayer.func_184600_cs());
            if (heldItem != null) {
                boolean isWhitelisted;
                boolean bl = isWhitelisted = heldItem.func_77973_b() instanceof ItemBLSword || heldItem.func_77973_b() instanceof ItemBLAxe || heldItem.func_77973_b() instanceof ItemBLPickaxe || heldItem.func_77973_b() instanceof ItemBLShovel || OverworldItemHandler.WHITELIST.contains(heldItem.func_77973_b());
                if (!isWhitelisted) {
                    damage *= 0.3f;
                }
            }
        }
        damage = CircleGemHelper.handleAttack(source, attackedEntity, damage);
        if (source.func_76346_g() instanceof EntityLivingBase && (attacker = (EntityLivingBase)source.func_76346_g()).hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
            IEquipmentCapability cap = (IEquipmentCapability)attacker.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            IInventory inv = cap.getInventory(EnumEquipmentInventory.RING);
            int rings = 0;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ItemRegistry.RING_OF_POWER) continue;
                ++rings;
            }
            if (rings > 0) {
                TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessagePowerRingParticles((Entity)attackedEntity), new NetworkRegistry.TargetPoint(attackedEntity.field_71093_bK, attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, 32.0));
            }
            damage *= 1.0f + 0.5f * (float)rings;
        }
        event.setAmount(damage);
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnPowerRingParticles(Entity entityHit) {
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t + (double)entityHit.field_70130_N / 2.0, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.08, 0.05, 0.0));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v + (double)entityHit.field_70130_N / 2.0, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.0, 0.05, 0.08));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t - (double)entityHit.field_70130_N / 2.0, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(-0.08, 0.05, 0.0));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v - (double)entityHit.field_70130_N / 2.0, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.0, 0.05, -0.08));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t + (double)entityHit.field_70130_N / 2.0, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.08, -0.05, 0.0));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v + (double)entityHit.field_70130_N / 2.0, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.0, -0.05, 0.08));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t - (double)entityHit.field_70130_N / 2.0, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(-0.08, -0.05, 0.0));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v - (double)entityHit.field_70130_N / 2.0, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.0, -0.05, -0.08));
    }
}

