/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.common.item.tools.bow.EnumArrowType;
import thebetweenlands.common.registries.ItemRegistry;

public class EntityBLArrow
extends EntityArrow {
    private static final DataParameter<String> DW_TYPE = EntityDataManager.func_187226_a(EntityArrow.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DW_UUID = EntityDataManager.func_187226_a(EntityArrow.class, (DataSerializer)DataSerializers.field_187194_d);
    private boolean checkedShooter = false;
    private boolean inGround = false;
    private int inGroundTicks = 0;

    public EntityBLArrow(World worldIn) {
        super(worldIn);
    }

    public EntityBLArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityBLArrow(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
        this.field_70180_af.func_187227_b(DW_UUID, (Object)shooter.func_110124_au().toString());
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_TYPE, (Object)"");
        this.field_70180_af.func_187214_a(DW_UUID, (Object)"");
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("inGroundTicks", this.inGroundTicks);
        nbt.func_74778_a("arrowType", this.getArrowType().func_176610_l());
        nbt.func_74778_a("shooter", (String)this.func_184212_Q().func_187225_a(DW_UUID));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.inGroundTicks = nbt.func_74762_e("inGroundTicks");
        this.setType(EnumArrowType.getEnumFromString(nbt.func_74779_i("arrowType")));
        this.field_70180_af.func_187227_b(DW_UUID, (Object)"shooter");
    }

    public void func_70030_z() {
        if (this.field_70250_c == null && !this.checkedShooter) {
            try {
                UUID uuid = UUID.fromString((String)this.field_70180_af.func_187225_a(DW_UUID));
                if (uuid != null) {
                    this.field_70250_c = this.field_70170_p.func_152378_a(uuid);
                }
            }
            catch (Exception uuid) {
            }
            finally {
                this.checkedShooter = true;
            }
        }
        if (this.inGround) {
            ++this.inGroundTicks;
        }
        if (!this.field_70170_p.field_72995_K && !this.inGround) {
            RayTraceResult collision = EntityBLArrow.getCollision(this);
            if (collision != null && collision.field_72313_a == RayTraceResult.Type.ENTITY && collision.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase hitEntity = (EntityLivingBase)collision.field_72308_g;
                switch (this.getArrowType()) {
                    case ANGLER_POISON: {
                        hitEntity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
                        break;
                    }
                    case OCTINE: {
                        if (hitEntity.func_70027_ad()) {
                            hitEntity.func_70015_d(9);
                            break;
                        }
                        hitEntity.func_70015_d(5);
                        break;
                    }
                    case BASILISK: {
                        break;
                    }
                }
            } else if (collision != null && collision.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.inGround = true;
            }
        }
        super.func_70030_z();
    }

    private static RayTraceResult getCollision(EntityArrow ea) {
        Vec3d start = new Vec3d(ea.field_70165_t, ea.field_70163_u, ea.field_70161_v);
        Vec3d dest = new Vec3d(ea.field_70165_t + ea.field_70159_w, ea.field_70163_u + ea.field_70181_x, ea.field_70161_v + ea.field_70179_y);
        RayTraceResult hit = ea.field_70170_p.func_147447_a(start, dest, false, true, false);
        start = new Vec3d(ea.field_70165_t, ea.field_70163_u, ea.field_70161_v);
        dest = new Vec3d(ea.field_70165_t + ea.field_70159_w, ea.field_70163_u + ea.field_70181_x, ea.field_70161_v + ea.field_70179_y);
        if (hit != null) {
            dest = new Vec3d(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c);
        }
        Entity collidedEntity = null;
        List entityList = ea.field_70170_p.func_72839_b((Entity)ea, ea.func_174813_aQ().func_72321_a(ea.field_70159_w, ea.field_70181_x, ea.field_70179_y).func_72314_b(1.05, 1.05, 1.05));
        double lastDistance = 0.0;
        for (Object anEntityList : entityList) {
            double currentDistance;
            AxisAlignedBB entityBoundingBox;
            RayTraceResult collision;
            Entity currentEntity = (Entity)anEntityList;
            if (!currentEntity.func_70067_L() || currentEntity == ea.field_70250_c && ea.field_70173_aa <= 5 || (collision = (entityBoundingBox = currentEntity.func_174813_aQ().func_72314_b((double)0.35f, (double)0.35f, (double)0.35f)).func_72327_a(start, dest)) == null || !((currentDistance = start.func_72438_d(collision.field_72307_f)) < lastDistance) && lastDistance != 0.0) continue;
            collidedEntity = currentEntity;
            lastDistance = currentDistance;
        }
        if (collidedEntity != null) {
            hit = new RayTraceResult(collidedEntity);
        }
        return hit;
    }

    public void setType(EnumArrowType type) {
        this.field_70180_af.func_187227_b(DW_TYPE, (Object)type.func_176610_l());
    }

    public EnumArrowType getArrowType() {
        return EnumArrowType.getEnumFromString((String)this.field_70180_af.func_187225_a(DW_TYPE));
    }

    protected ItemStack func_184550_j() {
        switch (this.getArrowType()) {
            case ANGLER_POISON: {
                return new ItemStack(ItemRegistry.POISONED_ANGLER_TOOTH_ARROW);
            }
            case OCTINE: {
                return new ItemStack(ItemRegistry.OCTINE_ARROW);
            }
            case BASILISK: {
                return new ItemStack(ItemRegistry.BASILISK_ARROW);
            }
        }
        return new ItemStack(ItemRegistry.ANGLER_TOOTH_ARROW);
    }
}

