/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.movement;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class FlightMoveHelper
extends EntityMoveHelper {
    protected int courseChangeCooldown;
    protected boolean blocked = false;

    public FlightMoveHelper(EntityLiving entity) {
        super(entity);
    }

    public void func_75641_c() {
        if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
            double dx = this.field_75646_b - this.field_75648_a.field_70165_t;
            double dy = this.field_75647_c - this.field_75648_a.field_70163_u;
            double dz = this.field_75644_d - this.field_75648_a.field_70161_v;
            double dist = dx * dx + dy * dy + dz * dz;
            if (this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.getCourseChangeCooldown();
                if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, dist = (double)MathHelper.func_76133_a((double)dist))) {
                    double speed = this.getFlightSpeed();
                    this.field_75648_a.field_70159_w += dx / dist * speed;
                    this.field_75648_a.field_70181_x += dy / dist * speed;
                    this.field_75648_a.field_70179_y += dz / dist * speed;
                    this.blocked = false;
                } else {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    this.blocked = true;
                }
            }
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    protected int getCourseChangeCooldown() {
        return this.field_75648_a.func_70681_au().nextInt(5) + 2;
    }

    protected boolean isNotColliding(double x, double y, double z, double step) {
        if (this.field_75648_a.field_70145_X) {
            return true;
        }
        double stepX = (x - this.field_75648_a.field_70165_t) / step;
        double stepY = (y - this.field_75648_a.field_70163_u) / step;
        double stepZ = (z - this.field_75648_a.field_70161_v) / step;
        AxisAlignedBB aabb = this.field_75648_a.func_174813_aQ();
        int i = 1;
        while ((double)i < step) {
            if (this.isBlocked(aabb = aabb.func_72317_d(stepX, stepY, stepZ))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isBlocked(AxisAlignedBB aabb) {
        return !this.field_75648_a.field_70170_p.func_184144_a((Entity)this.field_75648_a, aabb).isEmpty();
    }

    protected double getFlightSpeed() {
        return this.field_75645_e;
    }

    public static BlockPos getGroundHeight(World world, BlockPos pos, int maxIter, BlockPos fallback) {
        int i;
        if (world.func_175678_i(pos)) {
            return world.func_175645_m(pos);
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (i = 0; i < maxIter; ++i) {
            mutablePos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() - i, pos.func_177952_p());
            if (!world.func_175623_d((BlockPos)mutablePos)) break;
        }
        if (i < maxIter) {
            return new BlockPos(pos.func_177958_n(), pos.func_177956_o() - i, pos.func_177952_p());
        }
        return fallback;
    }
}

