/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;

@Deprecated
public class EntityWightOld
extends EntityMob
implements IEntityBL {
    public static final IAttribute VOLATILE_HEALTH_START_ATTRIB = new RangedAttribute(null, "bl.volatileHealthStart", 1.0, 0.0, 1.0).func_111117_a("Volatile Health Percentage Start");
    public static final IAttribute VOLATILE_COOLDOWN_ATTRIB = new RangedAttribute(null, "bl.volatileCooldown", 400.0, 10.0, 2.147483647E9).func_111117_a("Volatile Cooldown");
    public static final IAttribute VOLATILE_FLIGHT_SPEED_ATTRIB = new RangedAttribute(null, "bl.volatileFlightSpeed", 0.25, 0.0, 5.0).func_111117_a("Volatile Flight Speed");
    public static final IAttribute VOLATILE_LENGTH_ATTRIB = new RangedAttribute(null, "bl.volatileLength", 600.0, 0.0, 2.147483647E9).func_111117_a("Volatile Length");
    public static final IAttribute VOLATILE_MAX_DAMAGE_ATTRIB = new RangedAttribute(null, "bl.volatileMaxDamage", 20.0, 0.0, Double.MAX_VALUE).func_111117_a("Volatile Max Damage");
    private static final DataParameter<Byte> ATTACK_STATE_DW = EntityDataManager.func_187226_a(EntityWight.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> ANIMATION_STATE_DW = EntityDataManager.func_187226_a(EntityWight.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> VOLATILE_STATE_DW = EntityDataManager.func_187226_a(EntityWight.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> GUARD_STATE_DW = EntityDataManager.func_187226_a(EntityWight.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> REPAIR_X_DW = EntityDataManager.func_187226_a(EntityWight.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> REPAIR_Y_DW = EntityDataManager.func_187226_a(EntityWight.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> REPAIR_Z_DW = EntityDataManager.func_187226_a(EntityWight.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityAIAttackMelee meleeAttack = new EntityAIAttackMelee((EntityCreature)this, 0.5, false);
    private EntityPlayer previousTarget;
    private boolean updateHasBeenSeen = false;
    private int volatileCooldown = (int)VOLATILE_COOLDOWN_ATTRIB.func_111110_b() / 2 + 20;
    private int volatileProgress = 0;
    private float volatileReceivedDamage = 0.0f;
    private double waypointX;
    private double waypointY;
    private double waypointZ;
    private boolean prevVolatile = false;
    private String locationViolatorUUID = null;
    private boolean breakBlock = false;
    private Block repairBlock = null;
    private int repairMeta = 0;
    private int repairX = 0;
    private int repairY = 0;
    private int repairZ = 0;
    private boolean canTurnVolatile = true;
    private boolean canTurnVolatileOnTarget = false;

    public EntityWightOld(World world) {
        super(world);
        this.func_70105_a(0.7f, 2.2f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.meleeAttack);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_STATE_DW, (Object)0);
        this.field_70180_af.func_187214_a(ANIMATION_STATE_DW, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(VOLATILE_STATE_DW, (Object)0);
        this.field_70180_af.func_187214_a(GUARD_STATE_DW, (Object)0);
        this.field_70180_af.func_187214_a(REPAIR_X_DW, (Object)0);
        this.field_70180_af.func_187214_a(REPAIR_Y_DW, (Object)0);
        this.field_70180_af.func_187214_a(REPAIR_Z_DW, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(76.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(80.0);
        this.func_110140_aT().func_111150_b(VOLATILE_HEALTH_START_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_COOLDOWN_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_FLIGHT_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_LENGTH_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_MAX_DAMAGE_ATTRIB);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("volatileState", ((Byte)this.func_184212_Q().func_187225_a(VOLATILE_STATE_DW)).byteValue());
        nbt.func_74768_a("volatileCooldown", this.volatileCooldown);
        nbt.func_74768_a("volatileProgress", this.volatileProgress);
        nbt.func_74776_a("volatileReceivedDamage", this.volatileReceivedDamage);
        nbt.func_74757_a("isLocationGuard", this.isLocationGuard());
        if (this.locationViolatorUUID != null) {
            nbt.func_74778_a("locationViolatorUUID", this.locationViolatorUUID);
        }
        nbt.func_74757_a("isRepairGuard", this.isRepairGuard());
        nbt.func_74768_a("repairMeta", this.repairMeta);
        nbt.func_74768_a("repairX", this.repairX);
        nbt.func_74768_a("repairY", this.repairY);
        nbt.func_74768_a("repairZ", this.repairZ);
        nbt.func_74757_a("breakBlock", this.breakBlock);
        if (this.repairBlock != null) {
            nbt.func_74778_a("repairBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.repairBlock)).toString());
        }
        nbt.func_74757_a("canTurnVolatile", this.canTurnVolatile);
        nbt.func_74757_a("canTurnVolatileOnTarget", this.canTurnVolatileOnTarget);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(VOLATILE_STATE_DW, (Object)nbt.func_74771_c("volatileState"));
        this.volatileCooldown = nbt.func_74762_e("volatileCooldown");
        this.volatileProgress = nbt.func_74762_e("volatileProgress");
        this.volatileReceivedDamage = nbt.func_74760_g("volatileReceivedDamage");
        if (nbt.func_74767_n("isLocationGuard")) {
            this.field_70180_af.func_187227_b(GUARD_STATE_DW, (Object)1);
        }
        if (this.isLocationGuard() && nbt.func_74764_b("locationViolatorUUID")) {
            this.locationViolatorUUID = nbt.func_74779_i("locationViolatorUUID");
        }
        if (nbt.func_74767_n("isRepairGuard")) {
            this.field_70180_af.func_187227_b(GUARD_STATE_DW, (Object)2);
        }
        if (this.isRepairGuard()) {
            this.repairMeta = nbt.func_74762_e("repairMeta");
            this.repairX = nbt.func_74762_e("repairX");
            this.repairY = nbt.func_74762_e("repairY");
            this.repairZ = nbt.func_74762_e("repairZ");
            this.breakBlock = nbt.func_74767_n("breakBlock");
            this.repairBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("repairBlock")));
        }
        this.canTurnVolatile = nbt.func_74767_n("canTurnVolatile");
        this.canTurnVolatileOnTarget = nbt.func_74767_n("canTurnVolatileOnTarget");
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public int func_70641_bl() {
        return 3;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundRegistry.WIGHT_MOAN;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundRegistry.WIGHT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.WIGHT_DEATH;
    }

    public boolean canPossess(EntityLivingBase entity) {
        return !this.isRepairGuard() && (this.isLocationGuard() || !(entity instanceof EntityPlayer) || ((EntityPlayer)entity).field_71071_by.func_70301_a(103) == null || ((EntityPlayer)entity).field_71071_by.func_70301_a(103).func_77973_b() != ItemRegistry.SKULL_MASK);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.isLocationGuard() && (this.getViolator() == null || !this.getViolator().func_70089_S())) {
                this.func_70106_y();
            } else if (!this.isLocationGuard() || this.getViolator() != null) {
                // empty if block
            }
        }
        if (!this.isRepairGuard()) {
            EntityPlayer target;
            EntityPlayer entityPlayer = target = this.func_70638_az() instanceof EntityPlayer ? (EntityPlayer)this.func_70638_az() : null;
            if (target == null || target.field_70128_L || (double)target.func_70032_d((Entity)this) > this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()) {
                target = this.field_70170_p.func_184137_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 16.0, false);
            }
            if (target != null && !target.func_70093_af()) {
                this.setTargetSpotted(target, true);
            }
            if (target != null && target != this.previousTarget && target.func_70093_af()) {
                this.setTargetSpotted(target, false);
            }
            if (target == null && this.previousTarget != null) {
                this.setTargetSpotted(target, false);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70638_az() != null) {
                    if (this.getAnimation() > 0.0f) {
                        this.setAnimation(this.getAnimation() - 0.1f);
                    }
                } else {
                    if (this.getAnimation() < 1.0f) {
                        this.setAnimation(this.getAnimation() + 0.1f);
                    }
                    if (this.getAnimation() == 0.0f && this.previousTarget != null) {
                        this.previousTarget = null;
                    }
                }
            }
            if (this.func_70638_az() == null) {
                this.canTurnVolatileOnTarget = false;
            }
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
                this.field_70180_af.func_187227_b(ATTACK_STATE_DW, (Object)1);
                if (!this.isVolatile() && this.canPossess(this.func_70638_az()) && this.canTurnVolatile && this.canTurnVolatileOnTarget) {
                    if (this.volatileCooldown > 0) {
                        --this.volatileCooldown;
                    }
                    if ((double)this.func_110143_aJ() <= (double)this.func_110138_aP() * this.func_110148_a(VOLATILE_HEALTH_START_ATTRIB).func_111126_e() && this.volatileCooldown <= 0) {
                        this.setVolatile(true);
                        this.volatileCooldown = this.getVolatileCooldown() + this.field_70170_p.field_73012_v.nextInt(this.getVolatileCooldown()) + 20;
                        this.volatileProgress = 0;
                    }
                } else if (this.isVolatile() && !this.canPossess(this.func_70638_az())) {
                    this.setVolatile(false);
                }
            }
            if (this.isVolatile()) {
                if (this.func_70638_az() != null) {
                    if (this.func_184187_bx() == null) {
                        double dy;
                        double dx = this.func_70638_az().field_70165_t - this.field_70165_t;
                        double dz = this.func_70638_az().field_70161_v - this.field_70161_v;
                        if (this.func_70638_az() instanceof EntityLivingBase) {
                            EntityLivingBase entitylivingbase = this.func_70638_az();
                            dy = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
                        } else {
                            dy = (this.func_70638_az().func_174813_aQ().field_72338_b + this.func_70638_az().func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
                        }
                        double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        float pitch = (float)(-(Math.atan2(dy, dist) * 180.0 / Math.PI));
                        this.func_70101_b(yaw, pitch);
                        if (this.field_70170_p.field_72995_K) {
                            this.func_70034_d(yaw);
                        }
                    } else {
                        this.func_70101_b(this.func_184187_bx().field_70177_z, 0.0f);
                        if (this.field_70170_p.field_72995_K) {
                            this.func_70034_d(this.func_184187_bx().field_70177_z);
                        }
                    }
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.func_184187_bx() != null && this.func_184187_bx().field_70128_L) {
                        this.func_110145_l(this.func_184187_bx());
                    }
                    if ((double)this.volatileProgress < this.func_110148_a(VOLATILE_LENGTH_ATTRIB).func_111126_e()) {
                        ++this.volatileProgress;
                    }
                    if (this.volatileProgress >= 20) {
                        if (this.func_70638_az() != null) {
                            this.waypointX = this.func_70638_az().field_70165_t;
                            this.waypointY = this.func_70638_az().func_174813_aQ().field_72338_b + (this.func_70638_az().func_174813_aQ().field_72337_e - this.func_70638_az().func_174813_aQ().field_72338_b) / 2.0;
                            this.waypointZ = this.func_70638_az().field_70161_v;
                        } else {
                            this.waypointX = this.field_70165_t;
                            this.waypointY = this.field_70163_u;
                            this.waypointZ = this.field_70161_v;
                        }
                    } else {
                        this.waypointX = this.field_70165_t;
                        this.waypointY = this.field_70163_u + 3.0;
                        this.waypointZ = this.field_70161_v;
                    }
                    if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 1.0f) {
                        this.onCollideWithEntity(this.func_70638_az());
                    }
                    if (this.func_184187_bx() != null && this.field_70173_aa % 30 == 0) {
                        // empty if block
                    }
                } else if (this.func_184187_bx() == null || this.field_70173_aa % 4 == 0) {
                    this.spawnVolatileParticles();
                }
                this.func_70105_a(0.7f, 0.7f);
            } else {
                this.func_70105_a(0.7f, 2.2f);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
                this.field_70180_af.func_187227_b(ATTACK_STATE_DW, (Object)0);
            }
            if (this.prevVolatile != this.isVolatile()) {
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 80; ++i) {
                        double px = this.field_70165_t + (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.7f);
                        double py = this.field_70163_u + (double)(this.field_70170_p.field_73012_v.nextFloat() * 2.2f);
                        double pz = this.field_70161_v + (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.7f);
                        Vec3d vec = new Vec3d(px, py, pz).func_178788_d(new Vec3d(this.field_70165_t + (double)0.35f, this.field_70163_u + (double)1.1f, this.field_70161_v + (double)0.35f)).func_72432_b();
                        BLParticles.SWAMP_SMOKE.spawn(this.field_70170_p, px, py, pz, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(vec.field_72450_a * 0.25, vec.field_72448_b * 0.25, vec.field_72449_c * 0.25));
                    }
                }
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.WIGHT_ATTACK, SoundCategory.HOSTILE, 1.6f, 1.0f, false);
            }
            this.prevVolatile = this.isVolatile();
        } else {
            this.func_70624_b(null);
            this.setVolatile(true);
            this.waypointX = (double)this.repairX + 0.5;
            this.waypointY = (double)this.repairY + 0.5;
            this.waypointZ = (double)this.repairZ + 0.5;
            if (this.func_70011_f((double)this.repairX + 0.5, (double)this.repairY + 0.5, (double)this.repairZ + 0.5) <= this.func_110148_a(VOLATILE_FLIGHT_SPEED_ATTRIB).func_111126_e() + 0.1) {
                if (this.breakBlock) {
                    this.field_70170_p.func_175698_g(new BlockPos(this.repairX, this.repairY, this.repairZ));
                } else if (this.repairBlock != null) {
                    this.field_70170_p.func_180501_a(new BlockPos(this.repairX, this.repairY, this.repairZ), this.repairBlock.func_176203_a(this.repairMeta), 2);
                }
                this.func_70106_y();
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(REPAIR_X_DW, (Object)this.repairX);
                this.field_70180_af.func_187227_b(REPAIR_Y_DW, (Object)this.repairY);
                this.field_70180_af.func_187227_b(REPAIR_Z_DW, (Object)this.repairZ);
            } else {
                int i;
                this.spawnVolatileParticles();
                this.repairX = (Integer)this.func_184212_Q().func_187225_a(REPAIR_X_DW);
                this.repairY = (Integer)this.func_184212_Q().func_187225_a(REPAIR_Y_DW);
                this.repairZ = (Integer)this.func_184212_Q().func_187225_a(REPAIR_Z_DW);
                for (i = 0; i <= 2; ++i) {
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, (double)this.repairX + 0.5 * (double)i, this.repairY, this.repairZ);
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, (double)this.repairX + 0.5 * (double)i, this.repairY, this.repairZ + 1);
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, (double)this.repairX + 0.5 * (double)i, this.repairY + 1, this.repairZ);
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, (double)this.repairX + 0.5 * (double)i, this.repairY + 1, this.repairZ + 1);
                }
                for (i = 0; i <= 2; ++i) {
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX, (double)this.repairY + 0.5 * (double)i, this.repairZ);
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX, (double)this.repairY + 0.5 * (double)i, this.repairZ + 1);
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX + 1, (double)this.repairY + 0.5 * (double)i, this.repairZ);
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX + 1, (double)this.repairY + 0.5 * (double)i, this.repairZ + 1);
                }
                for (i = 0; i <= 2; ++i) {
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX, this.repairY, (double)this.repairZ + 0.5 * (double)i);
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX, this.repairY + 1, (double)this.repairZ + 0.5 * (double)i);
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX + 1, this.repairY, (double)this.repairZ + 0.5 * (double)i);
                    BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX + 1, this.repairY + 1, (double)this.repairZ + 0.5 * (double)i);
                }
            }
            AxisAlignedBB repairBB = new AxisAlignedBB((double)this.repairX, (double)this.repairY, (double)this.repairZ, (double)(this.repairX + 1), (double)(this.repairY + 1), (double)(this.repairZ + 1));
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, repairBB);
            for (EntityLivingBase entity : entities) {
                if (entity == this || entity instanceof EntityWight) continue;
                if (entity.field_70165_t < (double)this.repairX + 0.5) {
                    entity.field_70159_w = -0.5;
                } else if (entity.field_70165_t > (double)this.repairX + 0.5) {
                    entity.field_70159_w = 0.5;
                }
                if (entity.field_70163_u < (double)this.repairY + 0.5) {
                    entity.field_70181_x = -0.5;
                } else if (entity.field_70163_u > (double)this.repairY + 0.5) {
                    entity.field_70181_x = 0.5;
                }
                if (entity.field_70161_v < (double)this.repairZ + 0.5) {
                    entity.field_70179_y = -0.5;
                } else if (entity.field_70161_v > (double)this.repairZ + 0.5) {
                    entity.field_70179_y = 0.5;
                }
                entity.func_70097_a(DamageSource.field_76376_m, 4.0f);
                entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 160, 2));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 160, 2));
            }
        }
        super.func_70071_h_();
    }

    public void onCollideWithEntity(EntityLivingBase entity) {
        if (!this.field_70170_p.field_72995_K && this.isVolatile() && entity == this.func_70638_az()) {
            this.func_184205_a((Entity)entity, true);
            this.volatileProgress = 20;
        }
    }

    public void setLocationGuard(EntityPlayer violator) {
        this.field_70180_af.func_187227_b(GUARD_STATE_DW, (Object)1);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(999.0);
        this.func_70606_j(999.0f);
        this.locationViolatorUUID = violator.func_110124_au().toString();
    }

    public EntityPlayer getViolator() {
        if (this.locationViolatorUUID != null) {
            try {
                return this.field_70170_p.func_152378_a(UUID.fromString(this.locationViolatorUUID));
            }
            catch (Exception ex) {
                this.locationViolatorUUID = null;
            }
        }
        return null;
    }

    public boolean isLocationGuard() {
        return (Byte)this.field_70180_af.func_187225_a(GUARD_STATE_DW) == 1;
    }

    public void setRepairGuard(Block block, int x, int y, int z, int meta) {
        this.field_70180_af.func_187227_b(GUARD_STATE_DW, (Object)2);
        this.breakBlock = false;
        this.repairBlock = block;
        this.repairX = x;
        this.repairY = y;
        this.repairZ = z;
        this.repairMeta = meta;
    }

    public void setRepairGuard(int x, int y, int z) {
        this.field_70180_af.func_187227_b(GUARD_STATE_DW, (Object)2);
        this.breakBlock = true;
        this.repairX = x;
        this.repairY = y;
        this.repairZ = z;
    }

    public boolean isRepairGuard() {
        return (Byte)this.field_70180_af.func_187225_a(GUARD_STATE_DW) == 2;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVolatileParticles() {
        double radius = 0.3f;
        double cx = this.field_70165_t;
        double cy = this.field_70163_u + 0.35;
        double cz = this.field_70161_v;
        for (int i = 0; i < 8; ++i) {
            double px = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double py = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double pz = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            Vec3d vec = new Vec3d(px, py, pz).func_178788_d(new Vec3d((double)0.35f, (double)0.35f, (double)0.35f)).func_72432_b();
            px = cx + vec.field_72450_a * (double)0.3f;
            py = cy + vec.field_72448_b * (double)0.3f;
            pz = cz + vec.field_72449_c * (double)0.3f;
            BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, px, py, pz);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.isVolatile()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.isVolatile()) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.isVolatile()) {
            if (this.func_70090_H()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
            } else if (this.func_70072_I()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                float friction = 0.91f;
                if (this.field_70122_E) {
                    friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                float groundFriction = 0.16277136f / (friction * friction * friction);
                this.func_70060_a(strafe, forward, this.field_70122_E ? 0.1f * groundFriction : 0.02f);
                friction = 0.91f;
                if (this.field_70122_E) {
                    friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)friction;
                this.field_70181_x *= (double)friction;
                this.field_70179_y *= (double)friction;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double dx = this.field_70165_t - this.field_70169_q;
            double dz = this.field_70161_v - this.field_70166_s;
            float distanceMoved = MathHelper.func_76133_a((double)(dx * dx + dz * dz)) * 4.0f;
            if (distanceMoved > 1.0f) {
                distanceMoved = 1.0f;
            }
            this.field_70721_aZ += (distanceMoved - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.isVolatile()) {
            this.field_70145_X = true;
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            if ((double)this.volatileProgress >= this.func_110148_a(VOLATILE_LENGTH_ATTRIB).func_111126_e()) {
                this.field_70181_x -= 0.075;
                if (this.field_70122_E) {
                    this.setVolatile(false);
                }
            } else {
                double speed;
                double dx = this.waypointX - this.field_70165_t;
                double dy = this.waypointY - this.field_70163_u;
                double dz = this.waypointZ - this.field_70161_v;
                double dist = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                if (dist <= (speed = this.func_110148_a(VOLATILE_FLIGHT_SPEED_ATTRIB).func_111126_e())) {
                    this.waypointX = this.field_70165_t;
                    this.waypointY = this.field_70163_u;
                    this.waypointZ = this.field_70161_v;
                } else {
                    this.field_70159_w = dx / dist * speed;
                    this.field_70181_x = dy / dist * speed;
                    this.field_70179_y = dz / dist * speed;
                }
            }
        } else {
            this.field_70145_X = false;
        }
    }

    private void setTargetSpotted(EntityPlayer target, boolean hasBeenSeen) {
        if (hasBeenSeen) {
            if (!this.updateHasBeenSeen) {
                this.updateHasBeenSeen = true;
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.meleeAttack);
                this.func_70624_b((EntityLivingBase)target);
                this.previousTarget = target;
            }
        } else if (this.updateHasBeenSeen) {
            this.updateHasBeenSeen = false;
            this.func_70624_b(null);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.meleeAttack);
        }
    }

    private void setAnimation(float progress) {
        this.field_70180_af.func_187227_b(ANIMATION_STATE_DW, (Object)Float.valueOf(progress));
    }

    public float getAnimation() {
        return ((Float)this.field_70180_af.func_187225_a(ANIMATION_STATE_DW)).floatValue();
    }

    public boolean func_180431_b(DamageSource source) {
        return (Byte)this.field_70180_af.func_187225_a(ATTACK_STATE_DW) == 0;
    }

    public boolean func_70104_M() {
        return (Byte)this.field_70180_af.func_187225_a(ATTACK_STATE_DW) == 1;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (!this.isLocationGuard() && !this.isRepairGuard()) {
            this.func_70099_a(new ItemStack(ItemRegistry.WIGHT_HEART), 0.0f);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.isVolatile() && source == DamageSource.field_76368_d) {
            return false;
        }
        float prevHealth = this.func_110143_aJ();
        boolean ret = super.func_70097_a(source, damage);
        float dealtDamage = prevHealth - this.func_110143_aJ();
        if (this.isVolatile() && this.func_184187_bx() != null) {
            this.volatileReceivedDamage += dealtDamage;
            if ((double)this.volatileReceivedDamage >= this.func_110148_a(VOLATILE_MAX_DAMAGE_ATTRIB).func_111126_e()) {
                this.setVolatile(false);
            }
        }
        if (this.func_70638_az() != null && source instanceof EntityDamageSource && source.func_76346_g() == this.func_70638_az()) {
            this.canTurnVolatileOnTarget = true;
        }
        return ret;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isVolatile()) {
            return false;
        }
        if (super.func_70652_k(entity)) {
            if (entity == this.func_70638_az()) {
                this.canTurnVolatileOnTarget = true;
            }
            return true;
        }
        return false;
    }

    protected boolean func_70692_ba() {
        return !this.isLocationGuard() && !this.isRepairGuard();
    }

    public double func_70033_W() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer && this.field_70170_p.field_72995_K) {
            if (this.func_184187_bx() == TheBetweenlands.proxy.getClientPlayer()) {
                return -1.6;
            }
            return 0.05;
        }
        return 0.0;
    }

    public int getVolatileCooldown() {
        return (int)this.func_110148_a(VOLATILE_COOLDOWN_ATTRIB).func_111126_e();
    }

    public void setVolatile(boolean v) {
        if (!this.canTurnVolatile) {
            v = false;
        }
        this.field_70180_af.func_187227_b(VOLATILE_STATE_DW, (Object)((byte)(v ? 1 : 0)));
        this.volatileProgress = 0;
        this.volatileReceivedDamage = 0.0f;
        if (!v && this.func_184187_bx() != null) {
            this.func_110145_l(this.func_184187_bx());
            this.func_184210_p();
        }
    }

    public boolean isVolatile() {
        return (Byte)this.field_70180_af.func_187225_a(VOLATILE_STATE_DW) == 1;
    }

    public void setCanTurnVolatile(boolean canTurnVolatile) {
        this.canTurnVolatile = canTurnVolatile;
    }
}

