/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.ai.EntityAIBLAvoidEntity;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.AnimationMathHelper;

public class EntityLeech
extends EntityMob
implements IEntityBL {
    private static final int MAX_BLOOD_LEVEL = 5;
    private static final int TIME_TO_FLEE = 600;
    public int attackCountDown = 20;
    public int hungerCoolDown;
    private int drainage;
    public float moveProgress;
    public boolean firstTickCheck;
    public int fleeingTick;
    AnimationMathHelper mathSucking = new AnimationMathHelper();
    private EntityAINearestAttackableTarget<EntityLivingBase> aiAttackTarget;
    private EntityAIWander aiWander;
    private EntityAIAttackMelee aiAttackOnCollide;
    private EntityAIBLAvoidEntity aiAvoidHarmer;
    private static final DataParameter<Byte> BLOOD_CONSUMED = EntityDataManager.func_187226_a(EntityLeech.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityLeech(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.3f);
        this.field_70138_W = 0.0f;
        this.moveProgress = 0.0f;
        this.firstTickCheck = false;
        this.drainage = 0;
        this.setBloodConsumed(0);
    }

    protected void func_184651_r() {
        this.aiAttackTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, true, true);
        this.aiWander = new EntityAIWander((EntityCreature)this, 0.8);
        this.aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
        this.aiAvoidHarmer = new EntityAIBLAvoidEntity((EntityCreature)this, EntityPlayer.class, 6.0f, 0.5, 0.6);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiWander);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, this.aiAttackTarget);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BLOOD_CONSUMED, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public boolean func_175446_cd() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.SNAIL_LIVING;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundRegistry.SNAIL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.SNAIL_DEATH;
    }

    public void onCollideWithEntity(EntityLivingBase entity) {
        if (!this.field_70170_p.field_72995_K && !entity.func_184207_aI() && this.getBloodConsumed() <= 0) {
            this.func_184220_m((Entity)entity);
            this.func_184102_h().func_184103_al().func_148540_a((Packet)new SPacketSetPassengers((Entity)entity));
            this.field_70715_bh.func_85156_a(this.aiAttackTarget);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.fleeingTick == 0 && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 2.0f) {
                this.onCollideWithEntity(this.func_70638_az());
            }
            if (this.func_184187_bx() != null) {
                this.func_70101_b(this.func_184187_bx().field_70177_z, this.func_184187_bx().field_70125_A);
                if (this.func_184187_bx().func_70027_ad() && this.func_184187_bx() instanceof EntityLivingBase) {
                    PotionEffect stomachContents = new PotionEffect(MobEffects.field_76436_u, 120 + this.getBloodConsumed() * 200 / 5, 0);
                    ((EntityLivingBase)this.func_184187_bx()).func_70690_d(stomachContents);
                    this.setBloodConsumed(0);
                    Entity mount = this.func_184187_bx();
                    this.func_110145_l(mount);
                    this.flee();
                    this.func_184210_p();
                    this.func_184102_h().func_184103_al().func_148540_a((Packet)new SPacketSetPassengers(mount));
                }
            }
            if (this.getBloodConsumed() == 5 && this.func_184187_bx() != null) {
                this.func_110145_l(this.func_184187_bx());
                this.func_184210_p();
            }
            if (this.fleeingTick > 0) {
                --this.fleeingTick;
                if (this.fleeingTick == 0) {
                    this.stopFleeing();
                }
            }
        }
        if (!this.firstTickCheck) {
            this.func_184210_p();
            this.firstTickCheck = true;
        }
        if (--this.hungerCoolDown == 0 && this.getBloodConsumed() > 0) {
            this.setBloodConsumed(this.getBloodConsumed() - 1);
        }
        if (this.func_184187_bx() != null) {
            this.moveProgress = 1.0f + this.mathSucking.swing(1.0f, 0.15f, false);
            if (this.field_70146_Z.nextInt(10) == 0) {
                for (int i = 0; i < 8; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.moveProgress = 0.0f + this.mathSucking.swing(1.0f, 0.15f, false);
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityLivingBase && this.getBloodConsumed() < 5) {
            ++this.drainage;
            if (this.drainage >= this.attackCountDown && this.field_70725_aQ == 0) {
                this.func_184187_bx().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.drainage = 0;
                this.setBloodConsumed(this.getBloodConsumed() + 1);
            }
        }
        super.func_70071_h_();
    }

    private void flee() {
        this.fleeingTick = 600;
        if (!this.field_70170_p.field_72995_K) {
            this.aiAvoidHarmer.setTargetEntityClass(this.func_184187_bx().getClass());
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAvoidHarmer);
            this.field_70715_bh.func_85156_a(this.aiAttackTarget);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        }
    }

    private void stopFleeing() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAvoidHarmer);
            this.field_70715_bh.func_75776_a(0, this.aiAttackTarget);
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public double func_70033_W() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer && this.func_184187_bx() == TheBetweenlands.proxy.getClientPlayer()) {
            return -2.0;
        }
        return 0.0;
    }

    public boolean func_70686_a(Class entity) {
        return entity != EntityLeech.class && (entity == EntityPlayer.class || entity == EntityPlayerMP.class || entity == EntitySwampHag.class);
    }

    public int getBloodConsumed() {
        return (Byte)this.field_70180_af.func_187225_a(BLOOD_CONSUMED) & 0xFF;
    }

    public void setBloodConsumed(int amount) {
        this.hungerCoolDown = 500;
        this.field_70180_af.func_187227_b(BLOOD_CONSUMED, (Object)((byte)amount));
        if (amount == 0 && this.func_184187_bx() == null && !this.field_70170_p.field_72995_K) {
            this.field_70715_bh.func_75776_a(0, this.aiAttackTarget);
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.LEECH;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("bloodLevel", this.getBloodConsumed());
        nbttagcompound.func_74768_a("fleeingTick", this.fleeingTick);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("bloodLevel")) {
            this.setBloodConsumed(nbttagcompound.func_74762_e("bloodLevel"));
        }
        if (nbttagcompound.func_74764_b("fleeingTick")) {
            this.fleeingTick = nbttagcompound.func_74762_e("fleeingTick");
        }
    }
}

