/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityFrog
extends EntityCreature
implements IEntityBL {
    public static final IAttribute FROG_SKIN_ATTRIB = new RangedAttribute(null, "bl.frogSkin", 0.0, 0.0, 5.0).func_111117_a("Frog skin").func_111112_a(true);
    private static final DataParameter<Byte> DW_SWIM_STROKE = EntityDataManager.func_187226_a(EntityFrog.class, (DataSerializer)DataSerializers.field_187191_a);
    public int jumpAnimationTicks;
    public int prevJumpAnimationTicks;
    private int ticksOnGround = 0;
    private int strokeTicks = 0;

    public EntityFrog(World worldIn) {
        super(worldIn);
        this.func_184644_a(PathNodeType.WATER, 4.0f);
        this.func_70661_as().func_189566_q().func_186316_c(true);
        this.func_70105_a(0.7f, 0.5f);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 40));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_SWIM_STROKE, (Object)0);
    }

    public boolean func_175446_cd() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.05);
        this.func_110140_aT().func_111150_b(FROG_SKIN_ATTRIB);
        this.setSkin(this.field_70146_Z.nextInt(5));
    }

    public void func_70071_h_() {
        this.prevJumpAnimationTicks = this.jumpAnimationTicks;
        super.func_70071_h_();
        if (this.field_70122_E || this.strokeTicks == 0 && this.func_70090_H()) {
            ++this.ticksOnGround;
            if (this.jumpAnimationTicks > 0) {
                this.jumpAnimationTicks = 0;
            }
        } else {
            this.ticksOnGround = 0;
            ++this.jumpAnimationTicks;
        }
        if (this.strokeTicks > 0) {
            --this.strokeTicks;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.strokeTicks > 0) {
                --this.strokeTicks;
                this.field_70180_af.func_187227_b(DW_SWIM_STROKE, (Object)1);
            } else {
                this.field_70180_af.func_187227_b(DW_SWIM_STROKE, (Object)0);
            }
        } else if ((Byte)this.field_70180_af.func_187225_a(DW_SWIM_STROKE) == 1) {
            if (this.strokeTicks < 20) {
                ++this.strokeTicks;
            }
        } else {
            this.strokeTicks = 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            int index;
            this.func_70050_g(20);
            Path path = this.func_70661_as().func_75505_d();
            if (path != null && !path.func_75879_b() && (this.field_70122_E || this.func_70090_H()) && !this.func_70610_aX() && (index = path.func_75873_e()) < path.func_75874_d()) {
                PathPoint nextHopSpot = path.func_75877_a(index);
                float x = (float)((double)nextHopSpot.field_75839_a - this.field_70165_t);
                float z = (float)((double)nextHopSpot.field_75838_c - this.field_70161_v);
                float angle = (float)Math.atan2(z, x);
                float distance = (float)Math.sqrt(x * x + z * z);
                double speedMultiplier = Math.min((double)distance / 2.0, 1.0);
                if ((double)distance > 0.5) {
                    if (!this.func_70090_H()) {
                        if (this.ticksOnGround > 5) {
                            this.field_70181_x += 0.4;
                            this.field_70159_w += 0.4 * (double)MathHelper.func_76134_b((float)angle) * speedMultiplier;
                            this.field_70179_y += 0.4 * (double)MathHelper.func_76126_a((float)angle) * speedMultiplier;
                            this.field_70133_I = true;
                        }
                    } else if (this.strokeTicks == 0) {
                        this.field_70181_x += ((double)nextHopSpot.field_75837_b < this.field_70163_u ? -0.2 : 0.2) * speedMultiplier;
                        this.field_70159_w += 0.45 * (double)MathHelper.func_76134_b((float)angle) * speedMultiplier;
                        this.field_70179_y += 0.45 * (double)MathHelper.func_76126_a((float)angle) * speedMultiplier;
                        this.field_70133_I = true;
                        this.strokeTicks = 40;
                        this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                    } else if (this.field_70123_F) {
                        this.field_70159_w += 0.01 * (double)MathHelper.func_76134_b((float)angle);
                        this.field_70179_y += 0.01 * (double)MathHelper.func_76126_a((float)angle);
                    }
                } else {
                    path.func_75875_a();
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70181_x < 0.0 && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 0.4)), MathHelper.func_76128_c((double)this.field_70161_v))).func_185904_a().func_76224_d()) {
                    this.field_70181_x *= (double)0.1f;
                    this.field_70133_I = true;
                }
                if ((path == null || path.func_75879_b()) && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 0.5)), MathHelper.func_76128_c((double)this.field_70161_v))).func_185904_a().func_76224_d()) {
                    this.field_70181_x += (double)0.04f;
                    this.field_70133_I = true;
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.getSkin() == 4 && this.field_70170_p.func_72820_D() % 10L == 0L) {
            BLParticles.DIRT_DECAY.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
        }
    }

    public void func_70612_e(float strafing, float forward) {
        super.func_70612_e(0.0f, 0.0f);
    }

    public void func_70100_b_(EntityPlayer player) {
        super.func_70100_b_(player);
        int duration = 0;
        if (this.getSkin() == 4 && !this.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d && player.func_174813_aQ().field_72337_e >= this.func_174813_aQ().field_72338_b && player.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72337_e && player.func_174813_aQ().field_72336_d >= this.func_174813_aQ().field_72340_a && player.func_174813_aQ().field_72340_a <= this.func_174813_aQ().field_72336_d && player.func_174813_aQ().field_72334_f >= this.func_174813_aQ().field_72339_c && player.func_174813_aQ().field_72339_c <= this.func_174813_aQ().field_72334_f) {
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                duration = 5;
            } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                duration = 10;
            }
            if (duration > 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration * 20, 0));
            }
        }
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int getSkin() {
        return (int)this.func_110148_a(FROG_SKIN_ATTRIB).func_111126_e();
    }

    public void setSkin(int skinType) {
        this.func_110148_a(FROG_SKIN_ATTRIB).func_111128_a((double)skinType);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.FROG_LIVING;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundRegistry.FROG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.FROG_DEATH;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.FROG;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.strokeTicks = 0;
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70692_ba() {
        return false;
    }
}

