/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityScreenShake;
import thebetweenlands.client.audio.TeleporterSound;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.mobs.EntityFortressBoss;

public class EntityFortressBossTeleporter
extends Entity
implements IEntityScreenShake {
    protected static final DataParameter<Integer> TARGET_ID = EntityDataManager.func_187226_a(EntityFortressBossTeleporter.class, (DataSerializer)DataSerializers.field_187192_b);
    private Vec3d teleportDestination = Vec3d.field_186680_a;
    private Vec3d bossSpawnPosition = Vec3d.field_186680_a;
    private EntityPlayer target = null;
    private int teleportTicks = 0;
    private final int maxTeleportTicks = 75;
    public boolean isLookingAtPlayer = false;
    private boolean spawnedBoss = false;

    public EntityFortressBossTeleporter(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TARGET_ID, (Object)-1);
    }

    public void func_70108_f(Entity entity) {
    }

    public void func_70071_h_() {
        EntityPlayer closestPlayer;
        List players;
        AxisAlignedBB checkAABB;
        super.func_70071_h_();
        double radius = 6.0;
        double lookRadius = 8.0;
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                if (this.target == null) {
                    checkAABB = new AxisAlignedBB(this.field_70165_t - radius, this.field_70163_u - radius, this.field_70161_v - radius, this.field_70165_t + radius, this.field_70163_u + radius, this.field_70161_v + radius);
                    players = this.field_70170_p.func_72872_a(EntityPlayer.class, checkAABB);
                    closestPlayer = null;
                    for (EntityPlayer player : players) {
                        if (closestPlayer != null && !(player.func_70032_d((Entity)this) < closestPlayer.func_70032_d((Entity)this)) || !((double)player.func_70032_d((Entity)this) < radius) || !player.func_70685_l((Entity)this)) continue;
                        Vec3d playerLook = player.func_70676_i(1.0f).func_72432_b();
                        Vec3d vecDiff = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
                        double dist = vecDiff.func_72433_c();
                        double angle = playerLook.func_72430_b(vecDiff = vecDiff.func_72432_b());
                        if (!(angle > 1.0 - 0.01 / dist)) continue;
                        closestPlayer = player;
                    }
                    if (closestPlayer != null) {
                        this.target = closestPlayer;
                    }
                } else if ((double)this.target.func_70032_d((Entity)this) > radius) {
                    this.target = null;
                } else {
                    Vec3d playerLook = this.target.func_70676_i(1.0f).func_72432_b();
                    Vec3d vecDiff = new Vec3d(this.field_70165_t - this.target.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - (this.target.field_70163_u + (double)this.target.func_70047_e()), this.field_70161_v - this.target.field_70161_v);
                    double dist = vecDiff.func_72433_c();
                    double angle = playerLook.func_72430_b(vecDiff = vecDiff.func_72432_b());
                    if (angle <= 1.0 - (0.01 + Math.pow(this.getTeleportProgress(), 3.0) / 10.0) / dist) {
                        this.target = null;
                    }
                }
            } else {
                this.target = null;
            }
            if (this.target == null) {
                this.func_184212_Q().func_187227_b(TARGET_ID, (Object)-1);
            } else {
                this.func_184212_Q().func_187227_b(TARGET_ID, (Object)this.target.func_145782_y());
            }
        } else {
            EntityPlayer prevTarget = this.target;
            Entity target = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(TARGET_ID)).intValue());
            if (target instanceof EntityPlayer) {
                if (this.target == null) {
                    for (int i = 0; i < 60; ++i) {
                        this.spawnSmokeParticle(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.5f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.5f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.5f);
                    }
                }
                this.target = (EntityPlayer)target;
            } else {
                this.target = null;
            }
            if (this.target != null && prevTarget != this.target && this.field_70170_p.field_72995_K) {
                this.playTeleportSound();
            }
        }
        if (this.target != null) {
            this.faceEntity((Entity)this.target);
            ++this.teleportTicks;
            if (!this.field_70170_p.field_72995_K && this.teleportTicks > this.maxTeleportTicks) {
                if (this.target instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)this.target;
                    player.func_184210_p();
                    player.field_71135_a.func_147364_a(this.teleportDestination.field_72450_a, this.teleportDestination.field_72448_b, this.teleportDestination.field_72449_c, player.field_70177_z, player.field_70125_A);
                } else {
                    this.target.func_184210_p();
                    this.target.func_70012_b(this.teleportDestination.field_72450_a, this.teleportDestination.field_72448_b, this.teleportDestination.field_72449_c, this.target.field_70177_z, this.target.field_70125_A);
                }
                if (!this.spawnedBoss) {
                    this.spawnBoss();
                    this.spawnedBoss = true;
                }
                this.target = null;
                this.teleportTicks = 0;
            } else if (this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                double rx = this.field_70170_p.field_73012_v.nextFloat();
                double ry = this.field_70170_p.field_73012_v.nextFloat();
                double rz = this.field_70170_p.field_73012_v.nextFloat();
                double len = Math.sqrt(rx * rx + ry * ry + rz * rz);
                this.spawnSmokeParticle((double)((float)this.field_70165_t - this.field_70130_N / 2.0f) + rx, (double)((float)this.field_70163_u) + ry, (double)((float)this.field_70161_v - this.field_70130_N / 2.0f) + rz, (rx - 0.5) / len * 0.2, (ry - 0.5) / len * 0.2, (rz - 0.5) / len * 0.2);
            }
        } else {
            this.teleportTicks = 0;
            checkAABB = new AxisAlignedBB(this.field_70165_t - lookRadius, this.field_70163_u - lookRadius, this.field_70161_v - lookRadius, this.field_70165_t + lookRadius, this.field_70163_u + lookRadius, this.field_70161_v + lookRadius);
            players = this.field_70170_p.func_72872_a(EntityPlayer.class, checkAABB);
            closestPlayer = null;
            for (EntityPlayer player : players) {
                if (closestPlayer != null && !(player.func_70032_d((Entity)this) < closestPlayer.func_70032_d((Entity)this)) || !((double)player.func_70032_d((Entity)this) < lookRadius) || !player.func_70685_l((Entity)this)) continue;
                closestPlayer = player;
            }
            if (closestPlayer != null) {
                this.faceEntity((Entity)closestPlayer);
                if (this.field_70170_p.field_72995_K && !this.isLookingAtPlayer) {
                    for (int i = 0; i < 10; ++i) {
                        this.spawnSmokeParticle(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.5f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.5f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.5f);
                    }
                }
                this.isLookingAtPlayer = true;
            } else {
                this.isLookingAtPlayer = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playTeleportSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new TeleporterSound(this, (Entity)this.getTarget()));
    }

    public void faceEntity(Entity target) {
        float pitch;
        double dy;
        double dx = target.field_70165_t - this.field_70165_t;
        double dz = target.field_70161_v - this.field_70161_v;
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)target;
            double actualPosY = entitylivingbase.field_70163_u;
            dy = actualPosY + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            dy = (target.func_174813_aQ().field_72338_b + target.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        this.field_70125_A = this.field_70127_C = (pitch = (float)(-(Math.atan2(dy, dist) * 180.0 / Math.PI)));
        this.field_70177_z = this.field_70126_B = yaw;
    }

    public float getTeleportProgress() {
        float f = this.teleportTicks;
        this.getClass();
        return f / 75.0f;
    }

    public EntityPlayer getTarget() {
        return this.target;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        double dx = nbt.func_74769_h("destinationX");
        double dy = nbt.func_74769_h("destinationY");
        double dz = nbt.func_74769_h("destinationZ");
        this.teleportDestination = new Vec3d(dx, dy, dz);
        double sx = nbt.func_74769_h("bossSpawnX");
        double sy = nbt.func_74769_h("bossSpawnY");
        double sz = nbt.func_74769_h("bossSpawnZ");
        this.bossSpawnPosition = new Vec3d(sx, sy, sz);
        this.spawnedBoss = nbt.func_74767_n("spawnedBoss");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.teleportDestination != null) {
            nbt.func_74780_a("destinationX", this.teleportDestination.field_72450_a);
            nbt.func_74780_a("destinationY", this.teleportDestination.field_72448_b);
            nbt.func_74780_a("destinationZ", this.teleportDestination.field_72449_c);
        }
        if (this.bossSpawnPosition != null) {
            nbt.func_74780_a("bossSpawnX", this.bossSpawnPosition.field_72450_a);
            nbt.func_74780_a("bossSpawnY", this.bossSpawnPosition.field_72448_b);
            nbt.func_74780_a("bossSpawnZ", this.bossSpawnPosition.field_72449_c);
        }
        nbt.func_74757_a("spawnedBoss", this.spawnedBoss);
    }

    public void setTeleportDestination(Vec3d destination) {
        this.teleportDestination = destination;
    }

    public Vec3d getTeleportDestination() {
        return this.teleportDestination;
    }

    public void setBossSpawnPosition(Vec3d position) {
        this.bossSpawnPosition = position;
    }

    public Vec3d getBossSpawnPosition() {
        return this.bossSpawnPosition;
    }

    protected void spawnBoss() {
        EntityFortressBoss boss = new EntityFortressBoss(this.field_70170_p);
        boss.func_70107_b(this.bossSpawnPosition.field_72450_a, this.bossSpawnPosition.field_72448_b, this.bossSpawnPosition.field_72449_c);
        boss.setAnchor(this.bossSpawnPosition, 6.0);
        this.field_70170_p.func_72838_d((Entity)boss);
    }

    @Override
    public float getShakeIntensity(Entity viewer, float partialTicks) {
        if (this.getTarget() == viewer) {
            return (float)Math.pow(this.getTeleportProgress(), 3.0) / 2.0f;
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnSmokeParticle(double x, double y, double z, double mx, double my, double mz) {
        BLParticles.PORTAL.spawn(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(mx, my, mz));
    }
}

