/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.common.entity.mobs.EntityFortressBoss;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityFortressBossProjectile
extends Entity
implements IProjectile {
    protected static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityFortressBossProjectile.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> DEFLECTION_STATE = EntityDataManager.func_187226_a(EntityFortressBossProjectile.class, (DataSerializer)DataSerializers.field_187198_h);
    private UUID throwerUUID;
    private int ticksInAir = 0;
    private boolean canDismount = false;
    private Entity cachedOwner;
    private Entity cachedThrower;

    public EntityFortressBossProjectile(World world) {
        super(world);
        this.func_70105_a(0.65f, 0.65f);
        this.field_70145_X = true;
    }

    public EntityFortressBossProjectile(World world, Entity source) {
        this(world);
        this.setOwner(source);
        this.setThrower(source);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(OWNER, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(DEFLECTION_STATE, (Object)false);
    }

    public void setDeflectable(boolean deflectable) {
        this.func_184212_Q().func_187227_b(DEFLECTION_STATE, (Object)deflectable);
    }

    public boolean isDeflectable() {
        return (Boolean)this.func_184212_Q().func_187225_a(DEFLECTION_STATE);
    }

    public void setOwner(@Nullable Entity entity) {
        this.func_184212_Q().func_187227_b(OWNER, (Object)(entity == null ? Optional.absent() : Optional.of((Object)entity.func_110124_au())));
    }

    @Nullable
    public UUID getOwnerUUID() {
        Optional uuid = (Optional)this.func_184212_Q().func_187225_a(OWNER);
        return uuid.isPresent() ? (UUID)uuid.get() : null;
    }

    @Nullable
    public Entity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null) {
            this.cachedOwner = null;
        } else if (this.cachedOwner == null || !this.cachedOwner.func_70089_S() || !this.cachedOwner.func_110124_au().equals(uuid)) {
            this.cachedOwner = null;
            for (Entity entity : this.func_130014_f_().func_72872_a(Entity.class, this.func_174813_aQ().func_186662_g(64.0))) {
                if (!entity.func_110124_au().equals(uuid)) continue;
                this.cachedOwner = entity;
                break;
            }
        }
        return this.cachedOwner;
    }

    public void setThrower(@Nullable Entity entity) {
        this.throwerUUID = entity != null ? entity.func_110124_au() : null;
    }

    @Nullable
    public UUID getThrowerUUID() {
        return this.throwerUUID;
    }

    @Nullable
    public Entity getThrower() {
        UUID uuid = this.getThrowerUUID();
        if (uuid == null) {
            this.cachedThrower = null;
        } else if (this.cachedThrower == null || !this.cachedThrower.func_70089_S() || !this.cachedThrower.func_110124_au().equals(uuid)) {
            this.cachedThrower = null;
            for (Entity entity : this.func_130014_f_().func_72872_a(Entity.class, this.func_174813_aQ().func_186662_g(64.0))) {
                if (!entity.func_110124_au().equals(uuid)) continue;
                this.cachedThrower = entity;
                break;
            }
        }
        return this.cachedThrower;
    }

    protected void onImpact(RayTraceResult target) {
        if (!(target.field_72308_g instanceof EntityFortressBossProjectile)) {
            if (target.field_72308_g != null && target.field_72308_g instanceof EntityLivingBase) {
                if (target.field_72308_g instanceof EntityFortressBoss) {
                    EntityFortressBoss boss = (EntityFortressBoss)target.field_72308_g;
                    Vec3d ray = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    int shieldHit = boss.rayTraceShield(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), ray = ray.func_72432_b().func_186678_a(64.0), false);
                    if (shieldHit >= 0) {
                        if (!this.field_70170_p.field_72995_K) {
                            boss.setShieldActive(shieldHit, false);
                            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.FORTRESS_BOSS_SHIELD_DOWN, SoundCategory.HOSTILE, 1.0f, 1.0f);
                            double angle = 0.3490658503988659;
                            for (int i = 0; i < 18; ++i) {
                                Vec3d dir = new Vec3d(Math.sin(angle * (double)i), 0.0, Math.cos(angle * (double)i));
                                dir = dir.func_72432_b();
                                float speed = 0.8f;
                                EntityFortressBossProjectile bullet = new EntityFortressBossProjectile(this.field_70170_p, this.getOwner());
                                bullet.func_70012_b(boss.field_70165_t, boss.field_70163_u, boss.field_70161_v, 0.0f, 0.0f);
                                bullet.func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, speed, 0.0f);
                                this.field_70170_p.func_72838_d((Entity)bullet);
                            }
                        }
                    } else {
                        boss.func_70097_a(DamageSource.field_76377_j, 10.0f);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        boss.setFloating(false);
                    }
                } else {
                    target.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.getOwner()), 2.0f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
            } else if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.func_70106_y();
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.isDeflectable()) {
            ItemStack heldItem;
            this.func_70018_K();
            if (source.func_76346_g() instanceof EntityPlayer && (heldItem = ((EntityPlayer)source.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND)) != null && heldItem.func_77973_b() instanceof ItemSword && !this.field_70170_p.field_72995_K && source.func_76346_g().func_184188_bt().isEmpty()) {
                this.func_184205_a(source.func_76346_g(), true);
                this.func_184102_h().func_184103_al().func_148540_a((Packet)new SPacketSetPassengers(source.func_76346_g()));
                return true;
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        return false;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL || this.getOwner() != null && !this.getOwner().func_70089_S())) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70128_L) {
            if (this.func_184187_bx() == null) {
                ++this.ticksInAir;
                if (this.ticksInAir > 200) {
                    this.func_70106_y();
                }
                Vec3d currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                Vec3d nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                RayTraceResult hitObject = this.field_70170_p.func_72933_a(currentPos, nextPos);
                currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                if (hitObject != null) {
                    nextPos = new Vec3d(hitObject.field_72307_f.field_72450_a, hitObject.field_72307_f.field_72448_b, hitObject.field_72307_f.field_72449_c);
                }
                Entity hitEntity = null;
                List hitEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(0.1, 0.1, 0.1));
                double minDist = 0.0;
                for (int i = 0; i < hitEntities.size(); ++i) {
                    double d1;
                    Entity entity = (Entity)hitEntities.get(i);
                    if (!entity.func_70067_L() || entity == this.getThrower() || entity == this) continue;
                    float f = 0.1f;
                    AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                    RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(currentPos, nextPos);
                    if (movingobjectposition1 == null || !((d1 = currentPos.func_72438_d(movingobjectposition1.field_72307_f)) < minDist) && minDist != 0.0) continue;
                    hitEntity = entity;
                    minDist = d1;
                }
                if (hitEntity != null) {
                    hitObject = new RayTraceResult(hitEntity);
                }
                if (hitObject != null && hitObject.field_72308_g != this.getThrower()) {
                    this.onImpact(hitObject);
                }
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            } else if (this.func_184187_bx() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.func_184187_bx();
                ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
                if (!this.isDeflectable() || heldItem == null || !(heldItem.func_77973_b() instanceof ItemSword)) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70106_y();
                    }
                } else {
                    player.func_70110_aj();
                    player.field_70181_x -= 1.5;
                    if (player.field_82175_bq) {
                        if (this.canDismount) {
                            Vec3d look = this.func_184187_bx().func_70040_Z();
                            look.func_72432_b();
                            this.func_70186_c(look.field_72450_a, look.field_72448_b, look.field_72449_c, 0.5f, 0.0f);
                            this.func_184210_p();
                            this.setThrower((Entity)player);
                        }
                    } else {
                        this.canDismount = true;
                    }
                }
            }
        }
        super.func_70071_h_();
    }

    public void func_70186_c(double x, double y, double z, float speed, float randMotion) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
        this.field_70133_I = true;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_186855_b("owner")) {
            this.func_184212_Q().func_187227_b(OWNER, (Object)Optional.of((Object)nbt.func_186857_a("owner")));
        } else {
            this.func_184212_Q().func_187227_b(OWNER, (Object)Optional.absent());
        }
        this.throwerUUID = nbt.func_186855_b("thrower") ? nbt.func_186857_a("thrower") : null;
        this.ticksInAir = nbt.func_74762_e("ticksInAir");
        this.canDismount = nbt.func_74767_n("canDismount");
        this.setDeflectable(nbt.func_74767_n("deflectable"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.getOwnerUUID() != null) {
            nbt.func_186854_a("owner", this.getOwnerUUID());
        }
        if (this.getThrowerUUID() != null) {
            nbt.func_186854_a("thrower", this.getThrowerUUID());
        }
        nbt.func_74768_a("ticksInAir", this.ticksInAir);
        nbt.func_74757_a("canDismount", this.canDismount);
        nbt.func_74757_a("deflectable", this.isDeflectable());
    }
}

