/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.Random;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.ai.EntityAIFlyRandomly;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.registries.LootTableRegistry;

public class EntityFirefly
extends EntityFlying
implements IEntityBL {
    public static final IAttribute GLOW_STRENGTH_ATTRIB = new RangedAttribute(null, "bl.fireflyGlowStrength", 1.0, 0.0, 8.0).func_111117_a("Firefly glow strength").func_111112_a(true);
    public static final IAttribute GLOW_START_CHANCE = new RangedAttribute(null, "bl.fireflyGlowStartChance", 0.0025, 0.0, 1.0).func_111117_a("Firefly glow start chance per tick");
    public static final IAttribute GLOW_STOP_CHANCE = new RangedAttribute(null, "bl.fireflyGlowStopChance", 8.3E-4, 0.0, 1.0).func_111117_a("Firefly glow stop chance per tick");
    private static final DataParameter<Float> GLOW_STRENGTH = EntityDataManager.func_187226_a(EntityFirefly.class, (DataSerializer)DataSerializers.field_187193_c);
    protected double aboveLayer = 6.0;
    protected int glowTicks = 0;
    protected int prevGlowTicks = 0;

    public EntityFirefly(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.6f);
        this.field_70158_ak = true;
        this.field_70765_h = new FlightMoveHelper((EntityLiving)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFlyRandomly<EntityFirefly>(this){

            @Override
            protected double getTargetY(Random rand, double distanceMultiplier) {
                int worldHeight = MathHelper.func_76128_c((double)EntityFirefly.this.aboveLayer);
                BlockPos.PooledMutableBlockPos checkPos = BlockPos.PooledMutableBlockPos.func_185346_s();
                for (int yo = 0; yo < MathHelper.func_76143_f((double)EntityFirefly.this.aboveLayer); ++yo) {
                    checkPos.func_189532_c(((EntityFirefly)this.entity).field_70165_t, ((EntityFirefly)this.entity).field_70163_u - (double)yo, ((EntityFirefly)this.entity).field_70161_v);
                    if (!((EntityFirefly)this.entity).func_130014_f_().func_175667_e((BlockPos)checkPos)) {
                        return ((EntityFirefly)this.entity).field_70163_u;
                    }
                    if (((EntityFirefly)this.entity).func_130014_f_().func_175623_d((BlockPos)checkPos)) continue;
                    worldHeight = checkPos.func_177956_o();
                    break;
                }
                checkPos.func_185344_t();
                if (((EntityFirefly)this.entity).field_70163_u > (double)worldHeight + EntityFirefly.this.aboveLayer) {
                    return ((EntityFirefly)this.entity).field_70163_u + (double)(-rand.nextFloat() * 2.0f * 16.0f) * distanceMultiplier;
                }
                float rndFloat = rand.nextFloat() * 2.0f - 1.0f;
                if ((double)rndFloat > 0.0) {
                    double maxRange = (double)worldHeight + EntityFirefly.this.aboveLayer - ((EntityFirefly)this.entity).field_70163_u;
                    return ((EntityFirefly)this.entity).field_70163_u + (double)(-rand.nextFloat() * 2.0f) * maxRange * distanceMultiplier;
                }
                return ((EntityFirefly)this.entity).field_70163_u + (double)((rand.nextFloat() * 2.0f - 1.0f) * 16.0f) * distanceMultiplier;
            }

            @Override
            protected double getFlightSpeed() {
                return 0.035;
            }
        });
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110140_aT().func_111150_b(GLOW_STRENGTH_ATTRIB);
        this.func_110140_aT().func_111150_b(GLOW_START_CHANCE);
        this.func_110140_aT().func_111150_b(GLOW_STOP_CHANCE);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GLOW_STRENGTH, (Object)Float.valueOf((float)GLOW_STRENGTH_ATTRIB.func_111110_b()));
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.FIREFLY;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            this.field_70765_h.func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.1);
        }
        this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        this.prevGlowTicks = this.glowTicks;
        if (this.func_70089_S()) {
            if (!this.field_70170_p.field_72995_K) {
                if (!this.isGlowActive() && this.field_70146_Z.nextDouble() < this.func_110148_a(GLOW_START_CHANCE).func_111126_e()) {
                    this.setGlowStrength(this.func_110148_a(GLOW_STRENGTH_ATTRIB).func_111126_e());
                } else if (this.isGlowActive() && this.field_70146_Z.nextDouble() < this.func_110148_a(GLOW_STOP_CHANCE).func_111126_e()) {
                    this.setGlowStrength(0.0);
                }
            }
            if (this.isGlowActive() && this.glowTicks < 20) {
                ++this.glowTicks;
            } else if (!this.isGlowActive() && this.glowTicks > 0) {
                --this.glowTicks;
            }
        } else {
            this.setGlowStrength(0.0);
            this.glowTicks = 0;
        }
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74780_a("glowStrength", this.getGlowStrength());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGlowStrength(nbt.func_74769_h("glowStrength"));
    }

    public boolean isGlowActive() {
        return this.getGlowStrength() > 0.0;
    }

    public double getGlowStrength() {
        return ((Float)this.func_184212_Q().func_187225_a(GLOW_STRENGTH)).floatValue();
    }

    public void setGlowStrength(double strength) {
        this.func_184212_Q().func_187227_b(GLOW_STRENGTH, (Object)Float.valueOf((float)strength));
    }

    public float getGlowTicks(float partialTicks) {
        return (float)this.prevGlowTicks + (float)(this.glowTicks - this.prevGlowTicks) * partialTicks;
    }
}

