/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.ai.EntityAIDruidTeleport;
import thebetweenlands.common.entity.ai.EntityAIHurtByTargetDruid;
import thebetweenlands.common.entity.ai.EntityAINearestAttackableTargetDruid;
import thebetweenlands.common.network.clientbound.MessageDruidTeleportParticles;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityDarkDruid
extends EntityMob {
    private static final DataParameter<Boolean> CASTING = EntityDataManager.func_187226_a(EntityDarkDruid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final int MIN_ATTACK_DELAY = 40;
    private static final int MAX_ATTACK_DELAY = 120;
    private static final int MAX_ATTACK_TIME = 20;
    private static final int MAX_ATTACK_ANIMATION_TIME = 8;
    private EntityAIAttackMelee meleeAI;
    private EntityAIWander wanderAI;
    private EntityAIWatchClosest watchAI;
    private int attackDelayCounter;
    private int attackCounter;
    private int teleportCooldown;
    private boolean isWatching = true;
    private int prevAttackAnimationTime;
    private int attackAnimationTime;

    public EntityDarkDruid(World world) {
        super(world);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_70105_a(0.9f, 1.9f);
    }

    protected void func_184651_r() {
        this.meleeAI = new EntityAIAttackMelee((EntityCreature)this, (double)0.6f, true);
        this.wanderAI = new EntityAIWander((EntityCreature)this, (double)0.8f);
        this.watchAI = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.meleeAI);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, (double)0.23f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.wanderAI);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.watchAI);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIDruidTeleport(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetDruid(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTargetDruid(this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CASTING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null) {
                if (this.attackDelayCounter > 0 && !this.isCasting() && (double)this.func_70638_az().func_70032_d((Entity)this) < 10.0) {
                    --this.attackDelayCounter;
                }
                if ((this.attackDelayCounter <= 0 || this.attackCounter > 0) && this.func_70635_at().func_75522_a((Entity)this.func_70638_az())) {
                    if (this.attackCounter == 0) {
                        if (this.func_70638_az().field_70122_E) {
                            ++this.attackCounter;
                            if (!this.field_70170_p.field_72995_K) {
                                this.field_70714_bg.func_85156_a((EntityAIBase)this.meleeAI);
                            }
                        }
                    } else if (this.attackCounter < 20) {
                        ++this.attackCounter;
                        this.startCasting();
                        if (!this.field_70170_p.field_72995_K) {
                            this.chargeSpell((Entity)this.func_70638_az());
                        }
                    } else if (this.attackCounter >= 20) {
                        this.attackDelayCounter = 40 + this.field_70146_Z.nextInt(81) + 1;
                        this.attackCounter = 0;
                        this.stopCasting();
                        if (!this.field_70170_p.field_72995_K) {
                            this.castSpell((Entity)this.func_70638_az());
                            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.meleeAI);
                        }
                    }
                }
            } else if (this.isCasting() || this.attackCounter != 0) {
                if (this.attackDelayCounter <= 0) {
                    this.attackDelayCounter = 40 + this.field_70146_Z.nextInt(81) + 1;
                }
                this.attackCounter = 0;
                this.stopCasting();
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70760_ar = this.field_70126_B;
            this.field_70761_aq = this.field_70177_z;
            this.prevAttackAnimationTime = this.attackAnimationTime;
            if (this.isCasting()) {
                if (this.attackAnimationTime < 8) {
                    ++this.attackAnimationTime;
                }
                this.spawnParticles();
            } else if (this.attackAnimationTime > 0) {
                --this.attackAnimationTime;
            }
        } else {
            if (this.func_70638_az() != null) {
                this.func_70625_a((Entity)this.func_70638_az(), 100.0f, 100.0f);
            }
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            }
        }
    }

    private void enableWatch() {
        if (!this.isWatching) {
            this.isWatching = true;
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.watchAI);
        }
    }

    private void disableWatch() {
        if (this.isWatching) {
            this.isWatching = false;
            this.field_70714_bg.func_85156_a((EntityAIBase)this.watchAI);
        }
    }

    public boolean teleportNearEntity(Entity entity) {
        double targetX = entity.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 6.0;
        double targetY = entity.field_70163_u + (double)(this.field_70146_Z.nextInt(3) - 1);
        double targetZ = entity.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 6.0;
        double x = this.field_70165_t;
        double y = this.field_70163_u;
        double z = this.field_70161_v;
        boolean successful = false;
        BlockPos pos = this.func_180425_c();
        if (this.field_70170_p.func_175667_e(pos)) {
            boolean validBlock = false;
            while (!validBlock && pos.func_177956_o() > 0) {
                IBlockState block = this.field_70170_p.func_180495_p(pos.func_177977_b());
                if (block.func_185904_a().func_76230_c()) {
                    validBlock = true;
                    continue;
                }
                pos = pos.func_177977_b();
            }
            if (validBlock) {
                this.teleportCooldown = this.field_70146_Z.nextInt(40) + 40;
                EntityDarkDruid newDruid = new EntityDarkDruid(this.field_70170_p);
                newDruid.copyDataFromOld((Entity)this);
                newDruid.func_184221_a(UUID.randomUUID());
                newDruid.func_70107_b(targetX, targetY, targetZ);
                newDruid.func_70625_a(entity, 100.0f, 100.0f);
                newDruid.func_70624_b(this.func_70638_az());
                newDruid.attackDelayCounter = 40 + this.field_70146_Z.nextInt(81) + 1;
                if (this.field_70170_p.func_184144_a((Entity)newDruid, newDruid.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(newDruid.func_174813_aQ())) {
                    successful = true;
                    this.func_70106_y();
                    this.field_70170_p.func_72838_d((Entity)newDruid);
                    this.druidParticlePacketOrigin();
                    this.druidParticlePacketTarget(newDruid);
                } else {
                    newDruid.func_70106_y();
                }
            }
        }
        if (successful) {
            this.func_184185_a(SoundRegistry.DRUID_TELEPORT, 1.0f, 1.0f);
            return true;
        }
        this.func_70107_b(x, y, z);
        return false;
    }

    private void druidParticlePacketTarget(EntityDarkDruid newDruid) {
        World world = this.field_70170_p;
        if (world instanceof WorldServer) {
            int dim = ((WorldServer)world).field_73011_w.getDimension();
            TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageDruidTeleportParticles(newDruid), new NetworkRegistry.TargetPoint(dim, newDruid.field_70165_t + 0.5, newDruid.field_70163_u + 1.0, newDruid.field_70161_v + 0.5, 64.0));
        }
    }

    private void druidParticlePacketOrigin() {
        World world = this.field_70170_p;
        if (world instanceof WorldServer) {
            int dim = ((WorldServer)world).field_73011_w.getDimension();
            TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageDruidTeleportParticles(this), new NetworkRegistry.TargetPoint(dim, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5, 64.0));
        }
    }

    public void spawnParticles() {
        double yaw = this.field_70177_z * ((float)Math.PI / 180);
        double y = Math.cos(-this.field_70125_A * ((float)Math.PI / 180));
        double offsetX = -Math.sin(yaw) * 0.5 * y;
        double offsetY = 1.2 - Math.sin(-this.field_70125_A * ((float)Math.PI / 180)) * 0.5 * y;
        double offsetZ = Math.cos(yaw) * 0.5 * y;
        double motionX = -Math.sin(yaw) * y * 0.2 * (this.field_70146_Z.nextDouble() * 0.7 + 0.3) + this.field_70146_Z.nextDouble() * 0.05 - 0.025;
        double motionY = Math.sin(-this.field_70125_A * ((float)Math.PI / 180)) + this.field_70146_Z.nextDouble() * 0.25 - 0.125;
        double motionZ = Math.cos(yaw) * y * 0.2 * (this.field_70146_Z.nextDouble() * 0.7 + 0.3) + this.field_70146_Z.nextDouble() * 0.05 - 0.025;
        BLParticles.DRUID_CASTING.spawn(this.field_70170_p, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(motionX, motionY, motionZ)).withScale(this.field_70146_Z.nextFloat() + 0.5f));
    }

    public void chargeSpell(Entity entity) {
        if (entity.func_70032_d((Entity)this) <= 4.0f) {
            double dx = entity.field_70165_t - this.field_70165_t;
            double dz = entity.field_70161_v - this.field_70161_v;
            double len = Math.sqrt(dx * dx + dz * dz);
            entity.field_70159_w = 1.5 * dx / len;
            entity.field_70179_y = 1.5 * dz / len;
        } else {
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
        }
        entity.field_70181_x = 0.1;
        entity.field_70133_I = true;
    }

    public void castSpell(Entity entity) {
        double dx = entity.field_70165_t - this.field_70165_t;
        double dz = entity.field_70161_v - this.field_70161_v;
        double len = Math.sqrt(dx * dx + dz * dz);
        entity.field_70159_w = 0.5 * dx / len;
        entity.field_70179_y = 0.5 * dz / len;
        entity.field_70181_x = 1.05;
        entity.field_70133_I = true;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.DARK_DRUID;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public float func_180484_a(BlockPos pos) {
        return 0.0f;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public int func_70641_bl() {
        return 5;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.DARK_DRUID_LIVING;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundRegistry.DARK_DRUID_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.DARK_DRUID_DEATH;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public int getAttackCounter() {
        return this.attackCounter;
    }

    private void copyDataFromOld(Entity entity) {
        NBTTagCompound compound = entity.func_189511_e(new NBTTagCompound());
        compound.func_82580_o("Dimension");
        this.func_70020_e(compound);
    }

    public void startCasting() {
        this.field_70180_af.func_187227_b(CASTING, (Object)true);
        this.enableWatch();
    }

    public void stopCasting() {
        this.field_70180_af.func_187227_b(CASTING, (Object)false);
        this.disableWatch();
    }

    public boolean isCasting() {
        return (Boolean)this.field_70180_af.func_187225_a(CASTING);
    }

    public boolean canTeleport() {
        return !this.isCasting() && this.teleportCooldown == 0;
    }

    public float getAttackAnimationTime(float partialRenderTicks) {
        return ((float)this.prevAttackAnimationTime + (float)(this.attackAnimationTime - this.prevAttackAnimationTime) * partialRenderTicks) / 8.0f;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Teleport", this.teleportCooldown);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.teleportCooldown = tagCompound.func_74762_e("Teleport");
    }
}

