/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.ai.EntityAIFlyRandomly;
import thebetweenlands.common.entity.ai.EntityAIMoveToDirect;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityChiromaw
extends EntityFlying
implements IMob,
IEntityBL {
    private static final DataParameter<Boolean> IS_HANGING = EntityDataManager.func_187226_a(EntityChiromaw.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityChiromaw(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.9f);
        this.setIsHanging(false);
        this.field_70765_h = new FlightMoveHelper((EntityLiving)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveToDirect<EntityChiromaw>(this, 0.1){

            @Override
            protected Vec3d getTarget() {
                EntityLivingBase target;
                if (!((EntityChiromaw)this.entity).getIsHanging() && (target = ((EntityChiromaw)this.entity).func_70638_az()) != null) {
                    return new Vec3d(target.field_70165_t, target.field_70163_u + 1.0 - (double)((EntityChiromaw)this.entity).field_70146_Z.nextFloat() * 0.3, target.field_70161_v);
                }
                return null;
            }
        });
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlyRandomly<EntityChiromaw>(this){

            @Override
            protected double getTargetX(Random rand, double distanceMultiplier) {
                return ((EntityChiromaw)this.entity).field_70165_t + (double)((rand.nextFloat() * 2.0f - 1.0f) * 10.0f) * distanceMultiplier;
            }

            @Override
            protected double getTargetY(Random rand, double distanceMultiplier) {
                return ((EntityChiromaw)this.entity).field_70163_u + ((double)rand.nextFloat() * 1.75 - 1.0) * 10.0 * distanceMultiplier;
            }

            @Override
            protected double getTargetZ(Random rand, double distanceMultiplier) {
                return ((EntityChiromaw)this.entity).field_70161_v + (double)((rand.nextFloat() * 2.0f - 1.0f) * 10.0f) * distanceMultiplier;
            }

            @Override
            protected double getFlightSpeed() {
                return 0.08;
            }
        });
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_HANGING, (Object)false);
    }

    public void func_70071_h_() {
        EntityLivingBase attackTarget;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if ((attackTarget = this.func_70638_az()) != null && (attackTarget instanceof EntityPlayer && ((EntityPlayer)attackTarget).field_71075_bZ.field_75098_d || !this.func_70635_at().func_75522_a((Entity)attackTarget))) {
            this.func_70624_b(null);
        }
        if (this.field_70703_bu && this.func_70090_H()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.32);
        }
        if (this.getIsHanging()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.field_70163_u = (double)MathHelper.func_76128_c((double)this.field_70163_u) + 1.0 - (double)this.field_70131_O;
        } else {
            this.field_70181_x *= 0.6;
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getIsHanging()) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70765_h.func_75642_a(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0);
                if (this.field_70146_Z.nextInt(250) == 0 || !this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v)).func_185915_l()) {
                    this.setIsHanging(false);
                    this.field_70170_p.func_180498_a(null, 1025, this.func_180425_c(), 0);
                } else if (this.func_70638_az() != null) {
                    this.setIsHanging(false);
                    this.field_70170_p.func_180498_a(null, 1025, this.func_180425_c(), 0);
                }
            }
        } else if (this.func_70638_az() != null) {
            double distanceX = this.func_70638_az().field_70165_t - this.field_70165_t;
            double distanceZ = this.func_70638_az().field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(distanceX, distanceZ)) * 180.0f / (float)Math.PI;
        } else {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(20) == 0 && this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v)).func_185915_l()) {
                this.setIsHanging(true);
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean getIsHanging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HANGING);
    }

    public void setIsHanging(boolean hanging) {
        this.field_70180_af.func_187227_b(IS_HANGING, (Object)hanging);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.CHIROMAW;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.FLYING_FIEND_LIVING;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundRegistry.FLYING_FIEND_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.FLYING_FIEND_DEATH;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        return EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this, entityIn);
    }

    public int func_70641_bl() {
        return 3;
    }
}

