/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityAngler
extends EntityMob
implements IEntityBL {
    private static final DataParameter<Boolean> IS_LEAPING = EntityDataManager.func_187226_a(EntityAngler.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityAngler(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.7f);
        this.field_70765_h = new AnglerMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.7, true){

            protected double func_179512_a(EntityLivingBase attackTarget) {
                return 0.75 + (double)attackTarget.field_70130_N;
            }
        });
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.4, 80));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, null));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_LEAPING, (Object)false);
    }

    public boolean isLeaping() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LEAPING);
    }

    private void setIsLeaping(boolean leaping) {
        this.field_70180_af.func_187227_b(IS_LEAPING, (Object)leaping);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected SoundEvent func_184601_bQ() {
        return super.func_184601_bQ();
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.ANGLER_DEATH;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ANGLER;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == BlockRegistry.SWAMP_WATER;
    }

    public boolean isGrounded() {
        return !this.func_70090_H() && this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v))) && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().func_149703_v();
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateSwimmer((EntityLiving)this, world);
    }

    protected boolean func_70814_o() {
        return true;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.func_70090_H()) {
            Vec3d vec3d = this.func_174806_f(this.field_70125_A, this.field_70761_aq);
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3d.field_72450_a * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - vec3d.field_72448_b * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3d.field_72449_c * 1.5, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (this.field_70122_E) {
            this.field_70181_x += 0.25;
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.1f);
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.1f);
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            if (this.isLeaping()) {
                this.setIsLeaping(false);
            }
            this.field_70122_E = false;
            this.field_70160_al = true;
            if (this.field_70170_p.func_72820_D() % 5L == 0L) {
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187684_cg, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            this.func_70665_d(DamageSource.field_76369_e, 0.5f);
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        Double distance;
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && !this.field_70170_p.func_72953_d(this.func_70638_az().func_174813_aQ()) && (distance = Double.valueOf(this.func_180425_c().func_185332_f((int)this.func_70638_az().field_70165_t, (int)this.func_70638_az().field_70163_u, (int)this.func_70638_az().field_70161_v))) > 1.0 && distance < 6.0 && this.func_70090_H() && this.field_70170_p.func_175623_d(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u + 1, (int)this.field_70161_v))) {
            if (!this.isLeaping()) {
                this.setIsLeaping(true);
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187730_dW, SoundCategory.HOSTILE, 1.0f, 2.0f);
            }
            double distanceX = this.func_70638_az().field_70165_t - this.field_70165_t;
            double distanceZ = this.func_70638_az().field_70161_v - this.field_70161_v;
            float distanceSqrRoot = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
            this.field_70159_w = distanceX / (double)distanceSqrRoot * 0.5 * 0.900000011920929 + this.field_70159_w * 0.7000000029802322;
            this.field_70179_y = distanceZ / (double)distanceSqrRoot * 0.5 * 0.900000011920929 + this.field_70179_y * 0.7000000029802322;
            this.field_70181_x = 0.4;
        }
        super.func_70071_h_();
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_70060_a(strafe, forward, 0.1f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.9f;
                this.field_70181_x *= (double)0.9f;
                this.field_70179_y *= (double)0.9f;
                if (this.func_70638_az() == null) {
                    this.field_70181_x -= 0.005;
                }
            } else {
                super.func_70612_e(strafe, forward);
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            this.func_184185_a(SoundRegistry.ANGLER_ATTACK, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public boolean func_96092_aw() {
        return false;
    }

    static class AnglerMoveHelper
    extends EntityMoveHelper {
        private final EntityAngler angler;

        public AnglerMoveHelper(EntityAngler angler) {
            super((EntityLiving)angler);
            this.angler = angler;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.angler.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.angler.field_70165_t;
                double d1 = this.field_75647_c - this.angler.field_70163_u;
                double d2 = this.field_75644_d - this.angler.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.angler.field_70761_aq = this.angler.field_70177_z = this.func_75639_a(this.angler.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.angler.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.angler.func_70659_e(this.angler.func_70689_ay() + (f1 - this.angler.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.angler.field_70173_aa + this.angler.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.angler.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.angler.field_70177_z * ((float)Math.PI / 180));
                this.angler.field_70159_w += d4 * d5;
                this.angler.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.angler.field_70173_aa + this.angler.func_145782_y()) * 0.75) * 0.05;
                this.angler.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.angler.field_70181_x += (double)this.angler.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.angler.func_70671_ap();
                double d7 = this.angler.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.angler.func_70047_e() + this.angler.field_70163_u + d1 / d3;
                double d9 = this.angler.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.angler.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
            } else {
                this.angler.func_70659_e(0.0f);
            }
        }
    }
}

