/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.properties.EntityProperty;

public class LootPropertyHasItem
implements EntityProperty {
    private final boolean hasItem;
    private final boolean combineStacks;
    private final boolean held;
    private final boolean armor;
    private final boolean main;
    private final ItemStack item;
    private final StackSizeMatcher sizeMatcher;

    public LootPropertyHasItem(boolean hasItem, boolean combineStacks, ItemStack item, StackSizeMatcher sizeMatcher, boolean held, boolean armor, boolean main) {
        this.hasItem = hasItem;
        this.combineStacks = combineStacks;
        this.item = item;
        this.sizeMatcher = sizeMatcher;
        this.held = held;
        this.armor = armor;
        this.main = main;
    }

    public boolean func_186657_a(Random random, Entity entity) {
        int amount = -1;
        if (this.held) {
            for (ItemStack stack : entity.func_184214_aD()) {
                if (!this.doesItemMatch(stack)) continue;
                if (!this.combineStacks) {
                    if (!this.doesSizeMatch(stack.field_77994_a)) continue;
                    return this.hasItem;
                }
                ++amount;
            }
        }
        if (this.armor) {
            for (ItemStack stack : entity.func_184193_aE()) {
                if (!this.doesItemMatch(stack)) continue;
                if (!this.combineStacks) {
                    if (!this.doesSizeMatch(stack.field_77994_a)) continue;
                    return this.hasItem;
                }
                ++amount;
            }
        }
        if (this.main && entity instanceof EntityPlayer) {
            ItemStack[] inv = ((EntityPlayer)entity).field_71071_by.field_70462_a;
            for (int i = 0; i < inv.length; ++i) {
                ItemStack stack = inv[i];
                if (!this.doesItemMatch(stack)) continue;
                if (!this.combineStacks) {
                    if (!this.doesSizeMatch(stack.field_77994_a)) continue;
                    return this.hasItem;
                }
                ++amount;
            }
        }
        if (this.combineStacks && amount != -1 && this.sizeMatcher.matcher.apply(this.item.field_77994_a, amount + 1).booleanValue()) {
            return this.hasItem;
        }
        return !this.hasItem;
    }

    private boolean doesItemMatch(ItemStack stack) {
        if (this.item == null && stack == null) {
            return true;
        }
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() == this.item.func_77973_b() && (this.item.func_77952_i() == Short.MAX_VALUE || this.item.func_77952_i() == stack.func_77952_i());
    }

    private boolean doesSizeMatch(int size) {
        return this.sizeMatcher == null || this.sizeMatcher.matcher.apply(this.item.field_77994_a, size) != false;
    }

    public static class Serializer
    extends EntityProperty.Serializer<LootPropertyHasItem> {
        public Serializer() {
            super(new ResourceLocation("thebetweenlands", "has_item"), LootPropertyHasItem.class);
        }

        public JsonElement serialize(LootPropertyHasItem property, JsonSerializationContext serializationContext) {
            JsonObject obj = new JsonObject();
            obj.add("has_item", (JsonElement)new JsonPrimitive(Boolean.valueOf(property.hasItem)));
            obj.add("combine_stacks", (JsonElement)new JsonPrimitive(Boolean.valueOf(property.combineStacks)));
            JsonObject itemJson = new JsonObject();
            itemJson.add("id", (JsonElement)new JsonPrimitive(property.item.func_77973_b().getRegistryName().toString()));
            if (property.item.func_77952_i() != Short.MAX_VALUE) {
                itemJson.add("meta", (JsonElement)new JsonPrimitive((Number)property.item.func_77952_i()));
            }
            if (((LootPropertyHasItem)property).item.field_77994_a != 1) {
                itemJson.add("size", (JsonElement)new JsonPrimitive((Number)((LootPropertyHasItem)property).item.field_77994_a));
            }
            obj.add("item", (JsonElement)itemJson);
            JsonArray inventories = new JsonArray();
            if (property.held) {
                inventories.add((JsonElement)new JsonPrimitive("held"));
            }
            if (property.armor) {
                inventories.add((JsonElement)new JsonPrimitive("armor"));
            }
            if (property.main) {
                inventories.add((JsonElement)new JsonPrimitive("main"));
            }
            obj.add("inventories", (JsonElement)inventories);
            if (property.sizeMatcher != null) {
                switch (property.sizeMatcher) {
                    case GREATER: {
                        obj.add("size_operator", (JsonElement)new JsonPrimitive(">"));
                        break;
                    }
                    case GREATER_EQ: {
                        obj.add("size_operator", (JsonElement)new JsonPrimitive(">="));
                        break;
                    }
                    case LESS: {
                        obj.add("size_operator", (JsonElement)new JsonPrimitive("<"));
                        break;
                    }
                    case LESS_EQ: {
                        obj.add("size_operator", (JsonElement)new JsonPrimitive("<="));
                        break;
                    }
                    case EQUAL: {
                        obj.add("size_operator", (JsonElement)new JsonPrimitive("="));
                    }
                }
            }
            return obj;
        }

        public LootPropertyHasItem deserialize(JsonElement element, JsonDeserializationContext deserializationContext) {
            JsonObject obj = element.getAsJsonObject();
            boolean hasItem = obj.get("has_item").getAsBoolean();
            boolean combineStacks = obj.has("combine_stacks") ? obj.get("combine_stacks").getAsBoolean() : false;
            JsonObject itemJson = obj.get("item").getAsJsonObject();
            String id = itemJson.get("id").getAsString();
            int meta = itemJson.has("meta") ? itemJson.get("meta").getAsInt() : Short.MAX_VALUE;
            int size = itemJson.has("size") ? itemJson.get("size").getAsInt() : 1;
            ItemStack stack = new ItemStack(Item.func_111206_d((String)id), size, meta);
            boolean held = false;
            boolean armor = false;
            boolean main = false;
            JsonArray inventories = obj.get("inventories").getAsJsonArray();
            block24: for (JsonElement inventoryType : inventories) {
                switch (inventoryType.getAsString()) {
                    case "held": {
                        held = true;
                        continue block24;
                    }
                    case "armor": {
                        armor = true;
                        continue block24;
                    }
                    case "main": {
                        main = true;
                        continue block24;
                    }
                }
                throw new JsonParseException("Invalid inventory type. Valid inventory types: held, armor, main");
            }
            StackSizeMatcher sizeMatcher = null;
            if (obj.has("size_operator")) {
                String sizeOperator;
                switch (sizeOperator = obj.get("size_operator").getAsString()) {
                    case ">": {
                        sizeMatcher = StackSizeMatcher.GREATER;
                        break;
                    }
                    case "<": {
                        sizeMatcher = StackSizeMatcher.LESS;
                        break;
                    }
                    case ">=": {
                        sizeMatcher = StackSizeMatcher.GREATER_EQ;
                        break;
                    }
                    case "<=": {
                        sizeMatcher = StackSizeMatcher.LESS_EQ;
                        break;
                    }
                    case "=": {
                        sizeMatcher = StackSizeMatcher.EQUAL;
                        break;
                    }
                    default: {
                        throw new JsonParseException("Invalid size operator. Valid size operators: >, <, <=, >=, =");
                    }
                }
            }
            return new LootPropertyHasItem(hasItem, combineStacks, stack, sizeMatcher, held, armor, main);
        }
    }

    public static enum StackSizeMatcher {
        GREATER((o, i) -> i > o),
        GREATER_EQ((o, i) -> i >= o),
        LESS((o, i) -> i < o),
        LESS_EQ((o, i) -> i <= o),
        EQUAL((o, i) -> i == o);

        public final BiFunction<Integer, Integer, Boolean> matcher;

        private StackSizeMatcher(BiFunction<Integer, Integer, Boolean> matcher) {
            this.matcher = matcher;
        }
    }
}

