/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai.puppet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import thebetweenlands.api.capability.IPuppetCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class EntityAIPuppet
extends EntityAIBase {
    protected final EntityLivingBase taskOwner;
    protected final Supplier<Entity> puppeteer;
    protected final EntityAITasks tasks;

    public EntityAIPuppet(EntityLivingBase taskOwner, Supplier<Entity> puppeteer, @Nullable List<EntityAIBase> tasks) {
        this.taskOwner = taskOwner;
        this.puppeteer = puppeteer;
        if (tasks != null && !tasks.isEmpty()) {
            this.tasks = new EntityAITasks(taskOwner.field_70170_p.field_72984_F);
            for (int i = 0; i < tasks.size(); ++i) {
                this.tasks.func_75776_a(i, tasks.get(i));
            }
        } else {
            this.tasks = null;
        }
        this.func_75248_a(0);
    }

    public EntityAITasks getSubTasks() {
        return this.tasks;
    }

    public boolean func_75250_a() {
        return true;
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75246_d() {
        if (this.taskOwner instanceof EntityCreature) {
            IPuppetCapability targetCap;
            EntityCreature creature = (EntityCreature)this.taskOwner;
            EntityLivingBase target = creature.func_70638_az();
            if (target == this.puppeteer.get()) {
                creature.func_70624_b(null);
            } else if (target != null && target.hasCapability(CapabilityRegistry.CAPABILITY_PUPPET, null) && (targetCap = (IPuppetCapability)target.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)).getPuppeteer() == this.puppeteer.get()) {
                creature.func_70624_b(null);
            }
        }
        if (this.tasks != null) {
            this.tasks.func_75774_a();
        }
    }

    public static void addPuppetAI(Supplier<Entity> puppeteer, EntityLivingBase entity, EntityAITasks creatureTasks, @Nullable List<EntityAIBase> targetTasks) {
        EntityAIPuppet.interruptAI(creatureTasks);
        if (EntityAIPuppet.getPuppetAI(creatureTasks) == null) {
            creatureTasks.func_75776_a(Integer.MAX_VALUE, (EntityAIBase)new EntityAIPuppet(entity, puppeteer, targetTasks));
        }
    }

    public static void removePuppetAI(EntityAITasks creatureTasks) {
        EntityAIPuppet puppetAI = EntityAIPuppet.getPuppetAI(creatureTasks);
        if (puppetAI != null) {
            creatureTasks.func_85156_a((EntityAIBase)puppetAI);
        }
    }

    @Nullable
    public static EntityAIPuppet getPuppetAI(EntityAITasks creatureTasks) {
        for (EntityAITasks.EntityAITaskEntry entry : creatureTasks.field_75782_a) {
            if (!(entry.field_75733_a instanceof EntityAIPuppet)) continue;
            return (EntityAIPuppet)entry.field_75733_a;
        }
        return null;
    }

    public static void interruptAI(EntityAITasks creatureTasks) {
        ArrayList<EntityAITasks.EntityAITaskEntry> tasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
        for (EntityAITasks.EntityAITaskEntry entry : creatureTasks.field_75782_a) {
            if (entry.field_75733_a instanceof EntityAIPuppet) continue;
            tasks.add(entry);
        }
        for (EntityAITasks.EntityAITaskEntry ai : tasks) {
            creatureTasks.func_85156_a(ai.field_75733_a);
        }
        for (EntityAITasks.EntityAITaskEntry ai : tasks) {
            creatureTasks.func_75776_a(ai.field_75731_b, ai.field_75733_a);
        }
    }
}

