/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import java.util.function.Supplier;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFollowTarget
extends EntityAIBase {
    protected final EntityLiving taskOwner;
    protected final Supplier<EntityLivingBase> target;
    protected World theWorld;
    protected final double speed;
    protected final PathNavigate navigator;
    protected int timeToRecalcPath;
    protected float maxDist;
    protected float minDist;
    protected float oldWaterCost;

    public EntityAIFollowTarget(EntityLiving taskOwner, Supplier<EntityLivingBase> target, double speed, float minDist, float maxDist) {
        this.taskOwner = taskOwner;
        this.theWorld = taskOwner.field_70170_p;
        this.target = target;
        this.speed = speed;
        this.navigator = taskOwner.func_70661_as();
        this.minDist = minDist;
        this.maxDist = maxDist;
        if (!(taskOwner.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.target.get();
        if (target == null) {
            return false;
        }
        if (target instanceof EntityPlayer && ((EntityPlayer)target).func_175149_v()) {
            return false;
        }
        return !(this.taskOwner.func_70068_e((Entity)target) < (double)(this.minDist * this.minDist));
    }

    public boolean func_75253_b() {
        EntityLivingBase target = this.target.get();
        return target != null && !this.navigator.func_75500_f() && this.taskOwner.func_70068_e((Entity)target) > (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.taskOwner.func_184643_a(PathNodeType.WATER);
        this.taskOwner.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.navigator.func_75499_g();
        this.taskOwner.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    private boolean isEmptyBlock(BlockPos pos) {
        IBlockState blockState = this.theWorld.func_180495_p(pos);
        return blockState.func_185904_a() == Material.field_151579_a ? true : !blockState.func_185917_h();
    }

    public void func_75246_d() {
        EntityLivingBase target = this.target.get();
        if (target != null) {
            this.taskOwner.func_70671_ap().func_75651_a((Entity)target, 10.0f, (float)this.taskOwner.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.navigator.func_75497_a((Entity)target, this.speed) && !this.taskOwner.func_110167_bD() && this.taskOwner.func_70068_e((Entity)target) >= 144.0) {
                    int i = MathHelper.func_76128_c((double)target.field_70165_t) - 2;
                    int j = MathHelper.func_76128_c((double)target.field_70161_v) - 2;
                    int k = MathHelper.func_76128_c((double)target.func_174813_aQ().field_72338_b);
                    for (int l = 0; l <= 4; ++l) {
                        for (int i1 = 0; i1 <= 4; ++i1) {
                            if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.theWorld.func_180495_p(new BlockPos(i + l, k - 1, j + i1)).func_185896_q() || !this.isEmptyBlock(new BlockPos(i + l, k, j + i1)) || !this.isEmptyBlock(new BlockPos(i + l, k + 1, j + i1))) continue;
                            this.taskOwner.func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), this.taskOwner.field_70177_z, this.taskOwner.field_70125_A);
                            this.navigator.func_75499_g();
                            return;
                        }
                    }
                }
            }
        }
    }
}

