/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import thebetweenlands.common.entity.mobs.EntityGecko;
import thebetweenlands.common.registries.BlockRegistry;

public class EntityAIBLAvoidEntityGecko
extends EntityAIBase {
    public final Predicate<Entity> viableSelector = new Predicate<Entity>(){

        public boolean apply(Entity entity) {
            return entity.func_70089_S() && EntityAIBLAvoidEntityGecko.this.gecko.func_70635_at().func_75522_a(entity);
        }
    };
    private final Comparator<BlockPos> closest = (a, b) -> {
        double bLength;
        double aLength = a.func_185332_f(0, 0, 0);
        return aLength < (bLength = b.func_185332_f(0, 0, 0)) ? -1 : (aLength > bLength ? 1 : 0);
    };
    private EntityGecko gecko;
    private double farSpeed;
    private double nearSpeed;
    private Entity closestLivingEntity;
    private float distance;
    private Path path;
    private PathNavigate navigator;
    private Class<? extends Entity> avoidingEntityClass;
    private boolean bushBound;
    private BlockPos target;

    public EntityAIBLAvoidEntityGecko(EntityGecko gecko, Class<? extends Entity> avoidingEntityClass, float distance, double farSpeed, double nearSpeed) {
        this.gecko = gecko;
        this.avoidingEntityClass = avoidingEntityClass;
        this.distance = distance;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.navigator = gecko.func_70661_as();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.gecko.isHiding()) {
            return false;
        }
        if (this.avoidingEntityClass == EntityPlayer.class) {
            this.closestLivingEntity = this.gecko.field_70170_p.func_184136_b((Entity)this.gecko, (double)this.distance);
            if (this.closestLivingEntity == null) {
                return false;
            }
        } else {
            List list = this.gecko.field_70170_p.func_175647_a(this.avoidingEntityClass, this.gecko.func_174813_aQ().func_72314_b((double)this.distance, 3.0, (double)this.distance), this.viableSelector);
            if (list.isEmpty()) {
                return false;
            }
            this.closestLivingEntity = (Entity)list.get(0);
        }
        this.target = this.findNearBush();
        if (this.target == null) {
            Vec3d target = RandomPositionGenerator.func_75461_b((EntityCreature)this.gecko, (int)16, (int)7, (Vec3d)new Vec3d(this.closestLivingEntity.field_70165_t, this.closestLivingEntity.field_70163_u, this.closestLivingEntity.field_70161_v));
            if (target != null) {
                this.target = new BlockPos(target);
            }
        } else {
            this.bushBound = true;
        }
        if (this.target == null) {
            return false;
        }
        if (!this.bushBound && this.closestLivingEntity.func_174818_b(this.target) < this.closestLivingEntity.func_70068_e((Entity)this.gecko)) {
            return false;
        }
        this.path = this.navigator.func_179680_a(this.target);
        if (this.doesGeckoNeighborBush(this.target)) {
            this.gecko.setHidingBush(new BlockPos((Vec3i)this.target));
            this.gecko.startHiding();
            return false;
        }
        if (this.path != null) {
            PathPoint finalPathPoint = this.path.func_75870_c();
            return finalPathPoint.field_75839_a == this.target.func_177958_n() && finalPathPoint.field_75837_b == this.target.func_177956_o() && finalPathPoint.field_75838_c == this.target.func_177952_p() || this.bushBound && this.doesPathDestinationNeighborBush(this.target, this.path);
        }
        return false;
    }

    private boolean doesGeckoNeighborBush(BlockPos target) {
        BlockPos geckoPos = new BlockPos((Entity)this.gecko);
        for (EnumFacing facing : EnumFacing.values()) {
            if (!target.func_177972_a(facing).equals((Object)geckoPos)) continue;
            return true;
        }
        return false;
    }

    private boolean doesPathDestinationNeighborBush(BlockPos target, Path path) {
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos nearTarget = new BlockPos((Vec3i)target.func_177972_a(facing));
            PathPoint finalPathPoint = path.func_75870_c();
            if (finalPathPoint.field_75839_a != nearTarget.func_177958_n() || finalPathPoint.field_75837_b != nearTarget.func_177956_o() || finalPathPoint.field_75838_c != nearTarget.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private BlockPos findNearBush() {
        int radius = 8;
        BlockPos center = new BlockPos((Entity)this.gecko);
        Random rand = this.gecko.func_70681_au();
        ArrayList<BlockPos> bushes = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dx = -8; dx <= 8; ++dx) {
            for (int dy = -4; dy <= 8; ++dy) {
                for (int dz = -8; dz <= 8; ++dz) {
                    pos.func_181079_c(center.func_177958_n() + dx, center.func_177956_o() + dy, center.func_177952_p() + dz);
                    IBlockState state = this.gecko.field_70170_p.func_180495_p((BlockPos)pos);
                    if (state.func_177230_c() != BlockRegistry.WEEDWOOD_BUSH || !this.gecko.field_70170_p.func_175677_d(pos.func_177977_b(), false)) continue;
                    bushes.add(pos.func_177973_b((Vec3i)center));
                }
            }
        }
        if (bushes.size() == 0) {
            return null;
        }
        Collections.sort(bushes, this.closest);
        double targetDistance = ((BlockPos)bushes.get(0)).func_185332_f(0, 0, 0);
        double epsilon = 1.0E-8;
        int bushCount = bushes.size();
        for (int i = 0; i < bushCount; ++i) {
            boolean end;
            boolean bl = end = i == bushCount - 1;
            if (!(Math.abs(((BlockPos)bushes.get(i)).func_185332_f(0, 0, 0) - targetDistance) > 1.0E-8) && !end) continue;
            return ((BlockPos)bushes.get(rand.nextInt(end ? i + 1 : i))).func_177971_a((Vec3i)center);
        }
        throw new ConcurrentModificationException("I'm not sure how I feel about this...");
    }

    public boolean func_75253_b() {
        return !this.navigator.func_75500_f();
    }

    public void func_75249_e() {
        this.navigator.func_75484_a(this.path, this.farSpeed);
        this.gecko.setHidingBush(this.target);
    }

    public void func_75251_c() {
        if (this.bushBound && this.path.func_75879_b()) {
            this.gecko.startHiding();
        }
        this.closestLivingEntity = null;
        this.bushBound = false;
    }

    public void func_75246_d() {
        if (this.gecko.func_70068_e(this.closestLivingEntity) < 49.0) {
            this.gecko.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.gecko.func_70661_as().func_75489_a(this.farSpeed);
        }
    }
}

