/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIAttackOnCollide
extends EntityAIBase {
    protected World worldObj;
    protected EntityLiving attacker;
    protected int attackTick;
    protected boolean useStandardAttack;

    public EntityAIAttackOnCollide(EntityLiving entity) {
        this(entity, false);
    }

    public EntityAIAttackOnCollide(EntityLiving entity, boolean useStandardAttack) {
        this.attacker = entity;
        this.worldObj = entity.field_70170_p;
        this.useStandardAttack = useStandardAttack;
    }

    public boolean func_75250_a() {
        return this.attacker.func_70638_az() != null && this.attacker.func_70638_az().func_70089_S();
    }

    public boolean func_75253_b() {
        return this.attacker.func_70638_az() != null && this.attacker.func_70638_az().func_70089_S();
    }

    public void func_75246_d() {
        EntityLivingBase target = this.attacker.func_70638_az();
        this.attacker.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        double distSq = this.attacker.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.attackEntity(target, distSq);
    }

    protected void attackEntity(EntityLivingBase target, double distSq) {
        double d0 = this.getAttackReachSqr(target);
        if (distSq <= d0 && this.attackTick <= 0) {
            this.attackTick = 20;
            this.attacker.func_184609_a(EnumHand.MAIN_HAND);
            if (this.useStandardAttack) {
                EntityAIAttackOnCollide.useStandardAttack(this.attacker, (Entity)target);
            } else {
                this.attacker.func_70652_k((Entity)target);
            }
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return this.attacker.field_70130_N * 2.0f * this.attacker.field_70130_N * 2.0f + attackTarget.field_70130_N;
    }

    public static boolean useStandardAttack(EntityLiving attacker, Entity target) {
        boolean attacked;
        float attackDamage = attacker.func_110148_a(SharedMonsterAttributes.field_111264_e) != null ? (float)attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() : 2.0f;
        int knockBackModifier = 0;
        if (target instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_152377_a((ItemStack)attacker.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)target).func_70668_bt());
            knockBackModifier += EnchantmentHelper.func_77501_a((EntityLivingBase)attacker);
        }
        if (attacked = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)attacker), attackDamage)) {
            int fireAspectModifier;
            if (knockBackModifier > 0 && target instanceof EntityLivingBase) {
                ((EntityLivingBase)target).func_70653_a((Entity)attacker, (float)knockBackModifier * 0.5f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
                attacker.field_70159_w *= 0.6;
                attacker.field_70179_y *= 0.6;
            }
            if ((fireAspectModifier = EnchantmentHelper.func_90036_a((EntityLivingBase)attacker)) > 0) {
                target.func_70015_d(fireAspectModifier * 4);
            }
            if (target instanceof EntityPlayer) {
                ItemStack defenderItem;
                EntityPlayer entityplayer = (EntityPlayer)target;
                ItemStack attackerItem = attacker.func_184614_ca();
                ItemStack itemStack = defenderItem = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                if (attackerItem != null && defenderItem != null && attackerItem.func_77973_b() instanceof ItemAxe && defenderItem.func_77973_b() == Items.field_185159_cQ) {
                    float efficiencyModifier = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)attacker) * 0.05f;
                    if (attacker.field_70170_p.field_73012_v.nextFloat() < efficiencyModifier) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        attacker.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
        }
        return attacked;
    }
}

