/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thebetweenlands.common.entity.EntitySwordEnergy;

public class EntityShockwaveBlock
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<String> OWNER_DW = EntityDataManager.func_187226_a(EntitySwordEnergy.class, (DataSerializer)DataSerializers.field_187194_d);
    public Block block;
    public int blockMeta;
    public int jumpDelay;
    public BlockPos origin;
    private double waveStartX;
    private double waveStartZ;

    public EntityShockwaveBlock(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.setBlock(Blocks.field_150348_b, 0);
        this.field_70145_X = true;
    }

    public void setBlock(Block blockID, int blockMeta) {
        this.block = blockID;
        this.blockMeta = blockMeta;
    }

    public void setOwner(String ownerUUID) {
        this.field_70180_af.func_187227_b(OWNER_DW, (Object)ownerUUID);
    }

    public String getOwnerUUID() {
        return (String)this.field_70180_af.func_187225_a(OWNER_DW);
    }

    public Entity getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerUUID());
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    private Entity getEntityByUUID(UUID id) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!id.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    public void func_70071_h_() {
        this.field_70170_p.field_72984_F.func_76320_a("entityBaseTick");
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        if (this.field_70173_aa >= this.jumpDelay) {
            if (this.field_70173_aa == this.jumpDelay && this.field_70181_x <= 0.0) {
                this.field_70181_x += 0.25;
            } else {
                this.field_70181_x -= 0.05;
                if (!this.field_70170_p.field_72995_K && (this.field_70163_u <= (double)this.origin.func_177956_o() || this.field_70122_E)) {
                    this.func_70076_C();
                }
            }
        } else {
            this.field_70181_x = 0.0;
        }
        if (this.field_70163_u < -64.0) {
            this.func_70076_C();
        }
        if (this.field_70163_u + this.field_70181_x <= (double)this.origin.func_177956_o()) {
            this.field_70181_x = 0.0;
            this.func_70012_b(this.field_70165_t, this.origin.func_177956_o(), this.field_70161_v, 0.0f, 0.0f);
        } else {
            this.func_70091_d(0.0, this.field_70181_x, 0.0);
        }
        if (this.field_70181_x > 0.1 && !this.field_70170_p.field_72995_K) {
            Entity owner = this.getOwner();
            Object damageSource = owner != null ? new EntityDamageSourceIndirect("player", (Entity)this, owner) : DamageSource.field_76377_j;
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(0.1, 0.1, 0.1));
            for (EntityLivingBase entity : entities) {
                if (entity == null || !(entity instanceof EntityLivingBase) || !entity.func_70097_a(damageSource, 10.0f)) continue;
                float knockback = 1.5f;
                Vec3d dir = new Vec3d(this.field_70165_t - this.waveStartX, 0.0, this.field_70161_v - this.waveStartZ);
                dir = dir.func_72432_b();
                entity.field_70159_w = dir.field_72450_a * (double)knockback;
                entity.field_70181_x = 0.5;
                entity.field_70179_y = dir.field_72449_c * (double)knockback;
            }
        }
        this.field_70148_d = false;
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public boolean func_70072_I() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void writeSpawnData(ByteBuf data) {
        PacketBuffer buffer = new PacketBuffer(data);
        buffer.writeInt(Block.func_149682_b((Block)this.block));
        buffer.writeInt(this.blockMeta);
        buffer.func_179255_a(this.origin);
        buffer.writeInt(this.jumpDelay);
    }

    public void readSpawnData(ByteBuf data) {
        PacketBuffer buffer = new PacketBuffer(data);
        this.block = Block.func_149729_e((int)buffer.readInt());
        this.blockMeta = buffer.readInt();
        this.origin = buffer.func_179259_c();
        this.jumpDelay = buffer.readInt();
    }

    public void setOrigin(BlockPos pos, int delay, double waveStartX, double waveStartZ, Entity source) {
        this.origin = pos;
        this.jumpDelay = delay;
        this.waveStartX = waveStartX;
        this.waveStartZ = waveStartZ;
        this.setOwner(source.func_110124_au().toString());
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(OWNER_DW, (Object)"");
    }

    protected void func_70037_a(NBTTagCompound data) {
        this.block = Block.func_149729_e((int)data.func_74762_e("blockID"));
        if (this.block == null) {
            this.block = Blocks.field_150348_b;
        }
        this.blockMeta = data.func_74762_e("blockMeta");
        this.origin = new BlockPos(data.func_74762_e("originX"), data.func_74762_e("originY"), data.func_74762_e("originZ"));
        this.waveStartX = data.func_74769_h("waveStartX");
        this.waveStartZ = data.func_74769_h("waveStartZ");
        this.jumpDelay = data.func_74762_e("jumpDelay");
        this.setOwner(data.func_74779_i("ownerUUID"));
    }

    protected void func_70014_b(NBTTagCompound data) {
        data.func_74768_a("blockID", Block.func_149682_b((Block)this.block));
        data.func_74768_a("blockMeta", this.blockMeta);
        data.func_74768_a("originX", this.origin.func_177958_n());
        data.func_74768_a("originY", this.origin.func_177956_o());
        data.func_74768_a("originZ", this.origin.func_177952_p());
        data.func_74780_a("waveStartX", this.waveStartX);
        data.func_74780_a("waveStartZ", this.waveStartZ);
        data.func_74768_a("jumpDelay", this.jumpDelay);
        data.func_74778_a("ownerUUID", this.getOwnerUUID());
    }
}

