/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.command;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import thebetweenlands.api.aspect.DiscoveryContainer;
import thebetweenlands.common.herblore.aspect.AspectManager;

public class CommandAspectDiscovery
extends CommandBase {
    public String func_71517_b() {
        return "aspectDiscovery";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/aspectDiscovery <reset|discover> <held|all>";
    }

    public int func_82362_a() {
        return 2;
    }

    public List func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("reset");
            completions.add("discover");
        } else if (args.length == 2) {
            completions.add("all");
            completions.add("held");
        }
        return CommandAspectDiscovery.func_71530_a((String[])args, (String[])completions.toArray(new String[0]));
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("command.generic.noplayer", new Object[0]);
        }
        if (args.length < 2) {
            throw new CommandException("commands.generic.syntax", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (!DiscoveryContainer.hasDiscoveryProvider(player)) {
            throw new CommandException("command.aspectdiscovery.book.none", new Object[0]);
        }
        AspectManager manager = AspectManager.get(sender.func_130014_f_());
        block4 : switch (args[0]) {
            case "discover": {
                switch (args[1]) {
                    case "held": {
                        if (player.func_184614_ca() == null) {
                            throw new CommandException("command.aspectdiscovery.held.null", new Object[0]);
                        }
                        DiscoveryContainer<?> mergedKnowledge = DiscoveryContainer.getMergedDiscoveryContainer(player);
                        DiscoveryContainer.AspectDiscovery discovery = mergedKnowledge.discover(manager, AspectManager.getAspectItem(player.func_184614_ca()));
                        if (discovery.discovered == null) break block4;
                        DiscoveryContainer.addDiscoveryToContainers(player, AspectManager.getAspectItem(player.func_184614_ca()), discovery.discovered.type);
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aspectdiscovery.discover.held", new Object[]{new TextComponentString(discovery.result.toString()), new TextComponentString(discovery.discovered == null ? "null" : discovery.discovered.type.getName())}));
                        break block4;
                    }
                    case "all": {
                        List<DiscoveryContainer<?>> discoveryContainers = DiscoveryContainer.getWritableDiscoveryContainers(player);
                        for (DiscoveryContainer<?> container : discoveryContainers) {
                            container.discoverAll(manager);
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aspectdiscovery.discover.all", new Object[0]));
                        break block4;
                    }
                    default: {
                        throw new CommandException("commands.generic.syntax", new Object[0]);
                    }
                }
            }
            case "reset": {
                List<DiscoveryContainer<?>> discoveryContainers = DiscoveryContainer.getWritableDiscoveryContainers(player);
                switch (args[1]) {
                    case "held": {
                        if (player.func_184614_ca() == null) {
                            throw new CommandException("command.aspectdiscovery.held.null", new Object[0]);
                        }
                        for (DiscoveryContainer<?> container : discoveryContainers) {
                            container.resetDiscovery(AspectManager.getAspectItem(player.func_184614_ca()));
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aspectdiscovery.reset.held", new Object[0]));
                        break block4;
                    }
                    case "all": {
                        for (DiscoveryContainer<?> container : discoveryContainers) {
                            container.resetAllDiscovery();
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aspectdiscovery.reset.all", new Object[0]));
                        break block4;
                    }
                }
                throw new CommandException("commands.generic.syntax", new Object[0]);
            }
            default: {
                throw new CommandException("commands.generic.syntax", new Object[0]);
            }
        }
    }
}

