/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.foodsickness;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum FoodSickness {
    FINE(30),
    HALF(60),
    SICK(120);

    public final List<String> lines = new ArrayList<String>();
    public final int maxHatred;
    public static final FoodSickness[] VALUES;

    private FoodSickness(int maxHatred) {
        this.maxHatred = maxHatred;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.updateLines();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateLines() {
        this.lines.clear();
        int index = 0;
        while (I18n.func_188566_a((String)("chat.foodSickness." + this.name().toLowerCase() + "." + index))) {
            this.lines.add(I18n.func_135052_a((String)("chat.foodSickness." + this.name().toLowerCase() + "." + index), (Object[])new Object[0]));
            ++index;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getLines() {
        return this.lines;
    }

    @SideOnly(value=Side.CLIENT)
    public String getRandomLine(Random rnd) {
        List<String> lines = this.getLines();
        if (lines.isEmpty()) {
            return "chat.foodSickness.nolines";
        }
        return lines.get(rnd.nextInt(lines.size()));
    }

    public static FoodSickness getSicknessForHatred(int hatred) {
        for (FoodSickness sickness : VALUES) {
            if (sickness.maxHatred <= hatred) continue;
            return sickness;
        }
        return VALUES[VALUES.length - 1];
    }

    static {
        VALUES = FoodSickness.values();
    }

    public static class ResourceReloadListener
    implements IResourceManagerReloadListener {
        public void func_110549_a(IResourceManager resourceManager) {
            for (FoodSickness sickness : VALUES) {
                sickness.updateLines();
            }
        }
    }
}

