/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.equipment;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.registries.CapabilityRegistry;

public class EquipmentHelper {
    @Nullable
    public static ItemStack equipItem(@Nullable EntityPlayer player, Entity target, ItemStack stack, boolean simulate) {
        if (stack.func_77973_b() instanceof IEquippable && target.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
            IEquipmentCapability cap = (IEquipmentCapability)target.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            IEquippable equippable = (IEquippable)stack.func_77973_b();
            if (equippable.canEquip(stack, player, target)) {
                EnumEquipmentInventory type = equippable.getEquipmentCategory(stack);
                stack = stack.func_77946_l();
                IInventory inv = cap.getInventory(type);
                InvWrapper wrapper = new InvWrapper(inv);
                ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)wrapper, (ItemStack)stack, (boolean)true);
                if (simulate) {
                    return result;
                }
                if (result == null || result.field_77994_a != stack.field_77994_a) {
                    equippable.onEquip(stack, target, inv);
                    return ItemHandlerHelper.insertItem((IItemHandler)wrapper, (ItemStack)stack, (boolean)false);
                }
            }
        }
        return stack;
    }

    @Nullable
    public static ItemStack equipItem(@Nullable EntityPlayer player, Entity target, ItemStack stack, int slot, boolean simulate) {
        if (slot >= 0 && stack.func_77973_b() instanceof IEquippable && target.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
            EnumEquipmentInventory type;
            IInventory inv;
            IEquipmentCapability cap = (IEquipmentCapability)target.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            IEquippable equippable = (IEquippable)stack.func_77973_b();
            if (equippable.canEquip(stack, player, target) && slot < (inv = cap.getInventory(type = equippable.getEquipmentCategory(stack))).func_70302_i_()) {
                InvWrapper wrapper = new InvWrapper(inv);
                stack = stack.func_77946_l();
                ItemStack result = wrapper.insertItem(slot, stack, simulate);
                if (simulate) {
                    return result;
                }
                if (result == null || result.field_77994_a != stack.field_77994_a) {
                    equippable.onEquip(stack, target, inv);
                    return ItemHandlerHelper.insertItem((IItemHandler)wrapper, (ItemStack)stack, (boolean)false);
                }
            }
        }
        return stack;
    }

    @Nullable
    public static ItemStack unequipItem(@Nullable EntityPlayer player, Entity target, boolean simulate) {
        if (target.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
            IEquipmentCapability cap = (IEquipmentCapability)target.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            for (EnumEquipmentInventory type : EnumEquipmentInventory.values()) {
                IInventory inv = cap.getInventory(type);
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack != null && stack.func_77973_b() instanceof IEquippable && !((IEquippable)stack.func_77973_b()).canUnequip(stack, player, target, cap.getInventory(((IEquippable)stack.func_77973_b()).getEquipmentCategory(stack)))) continue;
                    if (simulate) {
                        return stack;
                    }
                    if (stack == null) continue;
                    if (stack.func_77973_b() instanceof IEquippable) {
                        ((IEquippable)stack.func_77973_b()).onUnequip(stack, target, inv);
                    }
                    inv.func_70299_a(i, null);
                    return stack;
                }
            }
        }
        return null;
    }

    @Nullable
    public static ItemStack unequipItem(@Nullable EntityPlayer player, Entity target, EnumEquipmentInventory type, int slot, boolean simulate) {
        if (target.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
            IEquipmentCapability cap = (IEquipmentCapability)target.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            IInventory inv = cap.getInventory(type);
            if (slot >= 0 && slot < inv.func_70302_i_()) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack != null && stack.func_77973_b() instanceof IEquippable && !((IEquippable)stack.func_77973_b()).canUnequip(stack, player, target, cap.getInventory(((IEquippable)stack.func_77973_b()).getEquipmentCategory(stack)))) {
                    return stack;
                }
                if (simulate) {
                    return stack;
                }
                if (stack != null && stack.func_77973_b() instanceof IEquippable) {
                    ((IEquippable)stack.func_77973_b()).onUnequip(stack, target, inv);
                }
                inv.func_70299_a(slot, null);
                return stack;
            }
        }
        return null;
    }

    public static boolean tryPlayerUnequip(EntityPlayer player, Entity target) {
        ItemStack unequipped = EquipmentHelper.unequipItem(player, target, false);
        if (unequipped != null) {
            if (!player.field_71071_by.func_70441_a(unequipped)) {
                target.func_70099_a(unequipped, target.func_70047_e());
            }
            return true;
        }
        return false;
    }
}

