/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.equipment;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.inventory.InventoryEquipment;
import thebetweenlands.common.inventory.InventoryEquipmentAmulets;
import thebetweenlands.common.registries.CapabilityRegistry;

public class EquipmentEntityCapability
extends EntityCapability<EquipmentEntityCapability, IEquipmentCapability, EntityPlayer>
implements IEquipmentCapability,
ISerializableCapability {
    private ItemStack[][] inventories = new ItemStack[EnumEquipmentInventory.values().length][];
    private int amuletSlots = 1;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "equipment");
    }

    @Override
    protected Capability<IEquipmentCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_EQUIPMENT;
    }

    @Override
    protected Class<IEquipmentCapability> getCapabilityClass() {
        return IEquipmentCapability.class;
    }

    @Override
    protected EquipmentEntityCapability getDefaultCapabilityImplementation() {
        return new EquipmentEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityLivingBase;
    }

    @Override
    public boolean isPersistent(EntityPlayer oldPlayer, EntityPlayer newPlayer, boolean wasDead) {
        return !wasDead || ((EntityPlayer)this.getEntity()).field_70170_p.func_82736_K().func_82766_b("keepInventory");
    }

    public EquipmentEntityCapability() {
        for (EnumEquipmentInventory inventory : EnumEquipmentInventory.values()) {
            this.inventories[inventory.id] = new ItemStack[inventory.maxSize];
        }
    }

    @Override
    public IInventory getInventory(EnumEquipmentInventory inventory) {
        switch (inventory) {
            case AMULET: {
                return new InventoryEquipmentAmulets(this, this.inventories[inventory.id]);
            }
        }
        return new InventoryEquipment(this, this.inventories[inventory.id]);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("amuletSlots", this.amuletSlots);
        NBTTagList inventoryList = new NBTTagList();
        for (int i = 0; i < this.inventories.length; ++i) {
            NBTTagCompound inventoryNbt = new NBTTagCompound();
            NBTTagList slotList = new NBTTagList();
            for (int c = 0; c < this.inventories[i].length; ++c) {
                ItemStack stack = this.inventories[i][c];
                if (stack == null) continue;
                NBTTagCompound slotNbt = new NBTTagCompound();
                slotNbt.func_74768_a("slot", c);
                slotNbt.func_74782_a("stack", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
                slotList.func_74742_a((NBTBase)slotNbt);
            }
            if (slotList.func_74745_c() <= 0) continue;
            inventoryNbt.func_74768_a("id", i);
            inventoryNbt.func_74782_a("items", (NBTBase)slotList);
            inventoryList.func_74742_a((NBTBase)inventoryNbt);
        }
        if (inventoryList.func_74745_c() > 0) {
            nbt.func_74782_a("inventories", (NBTBase)inventoryList);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        for (EnumEquipmentInventory inventory : EnumEquipmentInventory.values()) {
            this.inventories[inventory.id] = new ItemStack[inventory.maxSize];
        }
        if (nbt.func_74764_b("amuletSlots")) {
            this.amuletSlots = nbt.func_74762_e("amuletSlots");
        }
        if (nbt.func_74764_b("inventories")) {
            NBTTagList inventoryList = nbt.func_150295_c("inventories", 10);
            for (int i = 0; i < inventoryList.func_74745_c(); ++i) {
                int id;
                NBTTagCompound inventoryNbt = inventoryList.func_150305_b(i);
                if (!inventoryNbt.func_74764_b("items") || (id = inventoryNbt.func_74762_e("id")) >= this.inventories.length) continue;
                ItemStack[] inventoryStacks = this.inventories[id];
                NBTTagList slotList = inventoryNbt.func_150295_c("items", 10);
                for (int c = 0; c < slotList.func_74745_c(); ++c) {
                    NBTTagCompound slotNbt = slotList.func_150305_b(c);
                    int slot = slotNbt.func_74762_e("slot");
                    if (slot >= inventoryStacks.length) continue;
                    inventoryStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)slotNbt.func_74775_l("stack"));
                }
            }
        }
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }

    @Override
    public int getAmuletSlots() {
        return this.amuletSlots;
    }

    @Override
    public void setAmuletSlots(int slots) {
        this.amuletSlots = slots;
    }
}

