/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.decay;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import thebetweenlands.common.capability.decay.DecayEntityCapability;

public class DecayStats {
    private int decayLevel = 0;
    private int prevDecayLevel = 0;
    private float decaySaturationLevel = 5.0f;
    private float decayAccelerationLevel;
    private final DecayEntityCapability capability;

    public DecayStats(@Nullable DecayEntityCapability capability) {
        this.capability = capability;
    }

    public void addStats(int decay, float saturationModifier) {
        this.decayLevel = MathHelper.func_76125_a((int)(this.decayLevel + decay), (int)0, (int)20);
        this.decaySaturationLevel = MathHelper.func_76131_a((float)(this.decaySaturationLevel + (float)(-decay) * saturationModifier * 2.0f), (float)0.0f, (float)((float)(20 - this.decayLevel) / 4.0f));
        if (this.capability != null) {
            this.capability.markDirty();
        }
    }

    public void onUpdate(EntityPlayer player) {
        EnumDifficulty difficulty = player.field_70170_p.func_175659_aa();
        this.prevDecayLevel = this.decayLevel;
        if (difficulty != EnumDifficulty.PEACEFUL) {
            if (this.decayAccelerationLevel > 4.0f) {
                this.decayAccelerationLevel -= 4.0f;
                if (this.decaySaturationLevel > 0.0f) {
                    this.decaySaturationLevel = Math.max(this.decaySaturationLevel - 1.0f, 0.0f);
                } else {
                    this.decaySaturationLevel = 0.0f;
                    this.decayLevel = Math.min(this.decayLevel + 1, 20);
                    if (this.capability != null) {
                        this.capability.markDirty();
                    }
                }
            }
        } else if (this.getDecayLevel() < 20) {
            this.addStats(-1, 0.0f);
        }
    }

    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("decayLevel", 99)) {
            this.decayLevel = nbt.func_74762_e("decayLevel");
            this.decaySaturationLevel = nbt.func_74760_g("decaySaturationLevel");
            this.decayAccelerationLevel = nbt.func_74760_g("decayExhaustionLevel");
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("decayLevel", this.decayLevel);
        nbt.func_74776_a("decaySaturationLevel", this.decaySaturationLevel);
        nbt.func_74776_a("decayExhaustionLevel", this.decayAccelerationLevel);
    }

    public int getDecayLevel() {
        return this.decayLevel;
    }

    public int getPrevDecayLevel() {
        return this.prevDecayLevel;
    }

    public void addDecayAcceleration(float acceleration) {
        this.decayAccelerationLevel = Math.min(this.decayAccelerationLevel + acceleration, 40.0f);
    }

    public float getSaturationLevel() {
        return this.decaySaturationLevel;
    }

    public float getAccelerationLevel() {
        return this.decayAccelerationLevel;
    }

    public void setDecayLevel(int decay) {
        this.decayLevel = decay;
        if (this.capability != null) {
            this.capability.markDirty();
        }
    }

    public void setDecaySaturationLevel(float saturation) {
        this.decaySaturationLevel = saturation;
    }
}

