/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.decay;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.capability.decay.DecayStats;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.util.config.ConfigHandler;

public class DecayEntityCapability
extends EntityCapability<DecayEntityCapability, IDecayCapability, EntityPlayer>
implements IDecayCapability,
ISerializableCapability {
    private DecayStats decayStats = new DecayStats(this);

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "decay");
    }

    @Override
    protected Capability<IDecayCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_DECAY;
    }

    @Override
    protected Class<IDecayCapability> getCapabilityClass() {
        return IDecayCapability.class;
    }

    @Override
    protected DecayEntityCapability getDefaultCapabilityImplementation() {
        return new DecayEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public DecayStats getDecayStats() {
        return this.decayStats;
    }

    @Override
    public float getMaxPlayerHealth() {
        return Math.min(26.0f - (float)this.decayStats.getDecayLevel(), 20.0f);
    }

    @Override
    public boolean isDecayEnabled() {
        return ((EntityPlayer)this.getEntity()).field_71093_bK == ConfigHandler.dimensionId && !((EntityPlayer)this.getEntity()).field_71075_bZ.field_75098_d && !((EntityPlayer)this.getEntity()).field_71075_bZ.field_75102_a;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        this.decayStats.writeNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.decayStats.readNBT(nbt);
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 10;
    }
}

