/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.circlegem;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;

public enum CircleGemType {
    AQUA("aqua", 1),
    CRIMSON("crimson", 2),
    GREEN("green", 3),
    NONE("none", 0);

    public final String name;
    public final int id;
    public static final CircleGemType[] TYPES;

    private CircleGemType(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public int getRelation(CircleGemType gem) {
        switch (this) {
            case CRIMSON: {
                switch (gem) {
                    case GREEN: {
                        return 1;
                    }
                    case AQUA: {
                        return -1;
                    }
                }
                return 0;
            }
            case GREEN: {
                switch (gem) {
                    case AQUA: {
                        return 1;
                    }
                    case CRIMSON: {
                        return -1;
                    }
                }
                return 0;
            }
            case AQUA: {
                switch (gem) {
                    case CRIMSON: {
                        return 1;
                    }
                    case GREEN: {
                        return -1;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public boolean applyProc(boolean isAttacker, Entity owner, Entity source, Entity attacker, Entity defender, float strength) {
        switch (this) {
            case CRIMSON: {
                if (!isAttacker || !(defender instanceof EntityLivingBase)) break;
                double knockbackStrength = Math.min(0.22000000000000003 * (double)strength, 2.2);
                double mx = attacker.field_70165_t - defender.field_70165_t;
                double mz = attacker.field_70161_v - defender.field_70161_v;
                while (mx * mx + mz * mz < 1.0E-4) {
                    mx = (Math.random() - Math.random()) * 0.01;
                    mz = (Math.random() - Math.random()) * 0.01;
                }
                double len = Math.sqrt(mx * mx + mz * mz);
                ((EntityLivingBase)defender).func_70653_a(attacker, strength, mx * 6.0, mz * 6.0);
                defender.field_70159_w /= 2.0;
                defender.field_70181_x /= 2.0;
                defender.field_70179_y /= 2.0;
                defender.field_70159_w -= mx / len * knockbackStrength;
                defender.field_70181_x += 0.4;
                defender.field_70179_y -= mz / len * knockbackStrength;
                if (defender.field_70181_x > 0.4) {
                    defender.field_70181_x = 0.4;
                }
                if (attacker instanceof EntityLivingBase) {
                    ((EntityLivingBase)attacker).func_70690_d(new PotionEffect(MobEffects.field_76420_g, 110, Math.min(MathHelper.func_76141_d((float)(strength * 0.2f)), 2)));
                }
                if (source != attacker && source instanceof EntityLivingBase) {
                    ((EntityLivingBase)source).func_70690_d(new PotionEffect(MobEffects.field_76420_g, 110, Math.min(MathHelper.func_76141_d((float)(strength * 0.2f)), 2)));
                }
                return true;
            }
            case GREEN: {
                if (!isAttacker) break;
                boolean healed = false;
                if (attacker instanceof EntityLivingBase) {
                    ((EntityLivingBase)attacker).func_70691_i(Math.min(Math.max(strength * 0.45f, 1.0f), 10.0f));
                    healed = true;
                }
                if (source != attacker && source instanceof EntityLivingBase) {
                    ((EntityLivingBase)source).func_70691_i(Math.min(Math.max(strength * 0.45f, 1.0f), 10.0f));
                    healed = true;
                }
                return healed;
            }
            case AQUA: {
                if (isAttacker || !(defender instanceof EntityLivingBase)) break;
                ((EntityLivingBase)defender).func_70690_d(new PotionEffect(MobEffects.field_76429_m, 130, Math.min(MathHelper.func_76141_d((float)(strength * 0.3f)), 2)));
                return true;
            }
        }
        return false;
    }

    public static CircleGemType fromName(String name) {
        for (CircleGemType gem : TYPES) {
            if (!gem.name.equals(name)) continue;
            return gem;
        }
        return NONE;
    }

    public static CircleGemType fromID(int id) {
        for (CircleGemType gem : TYPES) {
            if (gem.id != id) continue;
            return gem;
        }
        return NONE;
    }

    static {
        TYPES = CircleGemType.values();
    }
}

