/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.circlegem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IEntityCircleGemCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.capability.circlegem.CircleGem;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.registries.CapabilityRegistry;

public class CircleGemEntityCapability
extends EntityCapability<CircleGemEntityCapability, IEntityCircleGemCapability, EntityLivingBase>
implements IEntityCircleGemCapability,
ISerializableCapability {
    private List<CircleGem> gems = new ArrayList<CircleGem>();

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "entity_gems");
    }

    @Override
    protected CircleGemEntityCapability getDefaultCapabilityImplementation() {
        return new CircleGemEntityCapability();
    }

    @Override
    protected Capability<IEntityCircleGemCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_ENTITY_CIRCLE_GEM;
    }

    @Override
    protected Class<IEntityCircleGemCapability> getCapabilityClass() {
        return IEntityCircleGemCapability.class;
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return CircleGemHelper.isApplicable(entity);
    }

    @Override
    public boolean isPersistent(EntityPlayer oldPlayer, EntityPlayer newPlayer, boolean wasDead) {
        return !wasDead || ((EntityLivingBase)this.getEntity()).func_130014_f_().func_82736_K().func_82766_b("keepInventory");
    }

    @Override
    public boolean canAdd(CircleGem gem) {
        return true;
    }

    @Override
    public void addGem(CircleGem gem) {
        if (this.canAdd(gem)) {
            this.gems.add(gem);
            this.markDirty();
        }
    }

    @Override
    public boolean removeGem(CircleGem gem) {
        Iterator<CircleGem> gemIT = this.gems.iterator();
        while (gemIT.hasNext()) {
            CircleGem currentGem = gemIT.next();
            if (currentGem.getGemType() != gem.getGemType() || currentGem.getCombatType() != gem.getCombatType()) continue;
            gemIT.remove();
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public List<CircleGem> getGems() {
        return Collections.unmodifiableList(this.gems);
    }

    @Override
    public boolean removeAll() {
        boolean hadGems = !this.gems.isEmpty();
        this.gems.clear();
        return hadGems;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList gemList = new NBTTagList();
        for (CircleGem gem : this.gems) {
            NBTTagCompound gemCompound = new NBTTagCompound();
            gem.writeToNBT(gemCompound);
            gemList.func_74742_a((NBTBase)gemCompound);
        }
        nbt.func_74782_a("gems", (NBTBase)gemList);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.gems.clear();
        NBTTagList gemList = nbt.func_150295_c("gems", 10);
        for (int i = 0; i < gemList.func_74745_c(); ++i) {
            NBTTagCompound gemCompound = gemList.func_150305_b(i);
            CircleGem gem = CircleGem.readFromNBT(gemCompound);
            if (gem == null) continue;
            this.gems.add(gem);
        }
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }
}

