/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.base;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.ItemCapability;

public class ItemCapabilityHandler {
    private static final List<ItemCapability<?, ?>> REGISTERED_CAPABILITIES = new ArrayList();

    public static <T, F extends ItemCapability<F, T>> void registerItemCapability(ItemCapability<F, T> itemCapability) {
        Preconditions.checkState((boolean)itemCapability.getCapabilityClass().isAssignableFrom(itemCapability.getClass()), (String)"Item capability %s must implement %s", (Object[])new Object[]{itemCapability.getClass().getName(), itemCapability.getCapabilityClass().getName()});
        REGISTERED_CAPABILITIES.add(itemCapability);
    }

    public static void registerCapabilities() {
        Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.PREINITIALIZATION));
        for (ItemCapability<?, ?> capability : REGISTERED_CAPABILITIES) {
            ItemCapabilityHandler.registerCapability(capability);
        }
    }

    private static <T> void registerCapability(final ItemCapability<?, T> capability) {
        CapabilityManager.INSTANCE.register(capability.getCapabilityClass(), new Capability.IStorage<T>(){

            public final NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
                if (instance instanceof ISerializableCapability) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    ((ISerializableCapability)instance).writeToNBT(nbt);
                    return nbt;
                }
                return null;
            }

            public final void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
                if (instance instanceof ISerializableCapability && nbt instanceof NBTTagCompound) {
                    ((ISerializableCapability)instance).readFromNBT((NBTTagCompound)nbt);
                }
            }
        }, new Callable<T>(){

            @Override
            public final T call() throws Exception {
                return capability.getDefaultCapabilityImplementation();
            }
        });
    }

    @SubscribeEvent
    public static void onAttachCapabilities(final AttachCapabilitiesEvent.Item event) {
        Item item = event.getItem();
        for (ItemCapability<?, ?> itemCapability : REGISTERED_CAPABILITIES) {
            if (!itemCapability.isApplicable(item)) continue;
            final Capability capabilityInstance = itemCapability.getCapability();
            event.addCapability(itemCapability.getID(), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                private Object itemCapability = this.getNewInstance();

                private ItemCapability<?, ?> getNewInstance() {
                    ItemCapability itemCapability = (ItemCapability)capabilityInstance.getDefaultInstance();
                    itemCapability.setStack(event.getItemStack());
                    itemCapability.init();
                    return itemCapability;
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == capabilityInstance;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == capabilityInstance ? this.itemCapability : null);
                }

                public NBTTagCompound serializeNBT() {
                    return this.serialize(capabilityInstance, this.itemCapability);
                }

                private <T> NBTTagCompound serialize(Capability<T> capability, Object instance) {
                    return (NBTTagCompound)capability.getStorage().writeNBT(capability, instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    this.deserialize(capabilityInstance, this.itemCapability, nbt);
                }

                private <T> void deserialize(Capability<T> capability, Object instance, NBTTagCompound nbt) {
                    capability.getStorage().readNBT(capability, instance, null, (NBTBase)nbt);
                }
            });
        }
    }
}

