/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.entity.mobs.EntityTarBeast;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockTar
extends BlockFluidClassic
implements BlockRegistry.IStateMappedBlock {
    public BlockTar() {
        super(FluidRegistry.TAR, BLMaterialRegistry.TAR);
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(!(entity instanceof EntityLivingBase) || entity instanceof EntityTarBeast || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d)) {
            double liquidHeight = (float)(pos.func_177956_o() + 1) - BlockLiquid.func_149801_b((int)((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b)));
            if (entity.field_70163_u + (double)entity.func_70047_e() < liquidHeight) {
                ((EntityLivingBase)entity).func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.solidifyTar(world, pos);
        super.func_176213_c(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        this.solidifyTar(world, pos);
        super.func_189540_a(state, world, pos, block);
    }

    private void solidifyTar(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == this) {
            boolean placeTar = false;
            if (!placeTar && world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_185904_a() == Material.field_151586_h) {
                placeTar = true;
            }
            if (!placeTar && world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_185904_a() == Material.field_151586_h) {
                placeTar = true;
            }
            if (!placeTar && world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_185904_a() == Material.field_151586_h) {
                placeTar = true;
            }
            if (!placeTar && world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_185904_a() == Material.field_151586_h) {
                placeTar = true;
            }
            if (!placeTar && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h) {
                placeTar = true;
            }
            if (!placeTar && world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h) {
                world.func_175656_a(pos.func_177977_b(), BlockRegistry.TAR_SOLID.func_176223_P());
            }
            if (placeTar) {
                world.func_175656_a(pos, BlockRegistry.TAR_SOLID.func_176223_P());
                if (world.field_72995_K) {
                    this.playEffects(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void playEffects(World world, int x, int y, int z) {
        world.func_184148_a(null, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)x + Math.random(), (double)y + 1.2, (double)z + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{LEVEL});
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState state, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        if (!(entity instanceof EntityTarBeast) && materialIn == Material.field_151586_h) {
            double liquidHeight = (float)(blockpos.func_177956_o() + 1) - BlockLiquid.func_149801_b((int)((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b)));
            if (testingHead) {
                double liquidHeightBelow = 0.0;
                if (world.func_180495_p(blockpos.func_177984_a()).func_177230_c() == state.func_177230_c()) {
                    liquidHeightBelow = (float)(blockpos.func_177956_o() + 2) - BlockLiquid.func_149801_b((int)((Integer)world.func_180495_p(blockpos.func_177984_a()).func_177229_b((IProperty)BlockLiquid.field_176367_b)));
                }
                return entity.field_70163_u + (double)entity.func_70047_e() < 0.1 + liquidHeight || entity.field_70163_u + (double)entity.func_70047_e() < 0.1 + liquidHeightBelow;
            }
            return entity.func_174813_aQ().field_72337_e >= liquidHeight && entity.func_174813_aQ().field_72338_b < liquidHeight;
        }
        return null;
    }

    public Vec3d func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        BlockPos entityPos = new BlockPos(entityIn.field_70165_t, entityIn.field_70163_u + 0.5, entityIn.field_70161_v);
        if (!(entityIn instanceof EntityTarBeast) && pos.equals((Object)entityPos)) {
            entityIn.field_70159_w *= 0.6;
            entityIn.field_70181_x *= 0.8;
            entityIn.field_70181_x -= 0.0175;
            entityIn.field_70179_y *= 0.6;
        }
        return new Vec3d(0.0, 0.0, 0.0);
    }
}

