/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockSwampWater
extends BlockFluidClassic
implements BlockRegistry.IStateMappedBlock,
ITintedBlock {
    private boolean isUnderwaterBlock = false;
    private static final int DEEP_COLOR_R = 19;
    private static final int DEEP_COLOR_G = 24;
    private static final int DEEP_COLOR_B = 68;

    public BlockSwampWater(Fluid fluid, Material material) {
        super(fluid, material);
    }

    public BlockSwampWater setUnderwaterBlock(boolean underwaterBlock) {
        this.isUnderwaterBlock = underwaterBlock;
        return this;
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSwampWater) {
            return false;
        }
        if (this.displacements.containsKey(state.func_177230_c())) {
            return (Boolean)this.displacements.get(state.func_177230_c());
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockSwampWater.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world instanceof World && !world.func_175667_e(pos)) {
            return false;
        }
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockSwampWater) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (((Boolean)this.displacements.get(block)).booleanValue()) {
                block.func_176226_b(world, pos, state, 0);
                return true;
            }
            return false;
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockSwampWater.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            block.func_176226_b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public float getFluidHeightForRender(IBlockAccess world, BlockPos pos) {
        IBlockState here = world.func_180495_p(pos);
        IBlockState up = world.func_180495_p(pos.func_177979_c(this.densityDir));
        if (here.func_177230_c() instanceof BlockSwampWater) {
            if (up.func_185904_a().func_76224_d() || up.func_177230_c() instanceof IFluidBlock) {
                return 1.0f;
            }
            if (((Integer)here.func_177229_b((IProperty)LEVEL)).intValue() == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        return !here.func_185904_a().func_76220_a() && up.func_177230_c() instanceof BlockSwampWater ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }

    public Vec3d getFlowVector(IBlockAccess world, BlockPos pos) {
        Vec3d vec = new Vec3d(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, pos);
        for (int side = 0; side < 4; ++side) {
            int power;
            boolean isOtherUnderwaterBlock;
            int x2 = pos.func_177958_n();
            int z2 = pos.func_177952_p();
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            BlockPos pos2 = new BlockPos(x2, pos.func_177956_o(), z2);
            IBlockState blockState1 = world.func_180495_p(pos);
            IBlockState blockState2 = world.func_180495_p(pos2);
            boolean isUnderwaterBlock = blockState1.func_177230_c() instanceof BlockSwampWater && ((BlockSwampWater)blockState1.func_177230_c()).isUnderwaterBlock;
            boolean bl = isOtherUnderwaterBlock = blockState2.func_177230_c() instanceof BlockSwampWater && ((BlockSwampWater)blockState2.func_177230_c()).isUnderwaterBlock;
            if (isUnderwaterBlock || isOtherUnderwaterBlock) continue;
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.func_180495_p(pos2).func_185904_a().func_76230_c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2.func_177977_b())) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.func_72441_c((double)((pos2.func_177958_n() - pos.func_177958_n()) * power), 0.0, (double)((pos2.func_177952_p() - pos.func_177952_p()) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.func_72441_c((double)((pos2.func_177958_n() - pos.func_177958_n()) * power), 0.0, (double)((pos2.func_177952_p() - pos.func_177952_p()) * power));
        }
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockSwampWater) {
            boolean flag;
            boolean bl = flag = this.func_176212_b(world, pos.func_177982_a(0, 0, -1), EnumFacing.NORTH) || this.func_176212_b(world, pos.func_177982_a(0, 0, 1), EnumFacing.SOUTH) || this.func_176212_b(world, pos.func_177982_a(-1, 0, 0), EnumFacing.WEST) || this.func_176212_b(world, pos.func_177982_a(1, 0, 0), EnumFacing.EAST) || this.func_176212_b(world, pos.func_177982_a(0, 1, -1), EnumFacing.NORTH) || this.func_176212_b(world, pos.func_177982_a(0, 1, 1), EnumFacing.SOUTH) || this.func_176212_b(world, pos.func_177982_a(-1, 1, 0), EnumFacing.WEST) || this.func_176212_b(world, pos.func_177982_a(1, 1, 0), EnumFacing.EAST);
            if (flag) {
                vec = vec.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
            }
        }
        vec = vec.func_72432_b();
        return vec;
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess worldIn, BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty((IUnlistedProperty)FLOW_DIRECTION, (Object)Float.valueOf((float)BlockSwampWater.getFlowDirection((IBlockAccess)worldIn, (BlockPos)pos)));
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        height[1][1] = this.getFluidHeightForRender(worldIn, pos);
        if (height[1][1] == 1.0f) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    corner[i][j] = 1.0f;
                }
            }
        } else {
            int j;
            int i;
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    if (i == 1 && j == 1) continue;
                    height[i][j] = this.getFluidHeightForRender(worldIn, pos.func_177982_a(i - 1, 0, j - 1));
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = this.getFluidHeightAverage(new float[]{height[i][j], height[i][j + 1], height[i + 1][j], height[i + 1][j + 1]});
                }
            }
        }
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[0], (Object)Float.valueOf(corner[0][0]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[1], (Object)Float.valueOf(corner[0][1]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[2], (Object)Float.valueOf(corner[1][1]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[3], (Object)Float.valueOf(corner[1][0]));
        return state;
    }

    public int getQuantaValue(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block blockHere = blockState.func_177230_c();
        if (!(blockHere instanceof BlockSwampWater) || !((BlockSwampWater)blockHere).isUnderwaterBlock) {
            return super.getQuantaValue(world, pos);
        }
        return this.quantaPerBlock;
    }

    public boolean isSourceBlock(IBlockAccess world, BlockPos pos) {
        return super.isSourceBlock(world, pos);
    }

    protected boolean canFlowInto(IBlockAccess world, BlockPos pos) {
        if (world instanceof World && !((World)world).func_175667_e(pos)) {
            return false;
        }
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSwampWater) {
            return true;
        }
        if (this.displacements.containsKey(state.func_177230_c())) {
            return (Boolean)this.displacements.get(state.func_177230_c());
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151586_h || material == Material.field_151587_i || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockSwampWater.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.func_180501_a(pos, BlockRegistry.SWAMP_WATER.func_176194_O().func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta)), 3);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int quantaRemaining = this.quantaPerBlock - (Integer)state.func_177229_b((IProperty)LEVEL);
        if (quantaRemaining < this.quantaPerBlock && !world.func_175623_d(pos.func_177977_b())) {
            int adjacentSources = 0;
            if (this.isSourceBlock((IBlockAccess)world, pos.func_177974_f())) {
                ++adjacentSources;
            }
            if (this.isSourceBlock((IBlockAccess)world, pos.func_177978_c())) {
                ++adjacentSources;
            }
            if (this.isSourceBlock((IBlockAccess)world, pos.func_177968_d())) {
                ++adjacentSources;
            }
            if (this.isSourceBlock((IBlockAccess)world, pos.func_177976_e())) {
                ++adjacentSources;
            }
            if (adjacentSources >= 2) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)), 2);
                quantaRemaining = this.quantaPerBlock;
            }
        }
        int expQuanta = -101;
        if (!(state.func_177230_c() instanceof BlockSwampWater) || !((BlockSwampWater)state.func_177230_c()).isUnderwaterBlock) {
            if (quantaRemaining < this.quantaPerBlock) {
                if (world.func_180495_p(pos.func_177982_a(0, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(-1, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(1, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(0, -this.densityDir, -1)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(0, -this.densityDir, 1)).func_177230_c() == this) {
                    expQuanta = this.quantaPerBlock - 1;
                } else {
                    int maxQuanta = -100;
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(-1, 0, 0), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(1, 0, 0), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(0, 0, -1), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(0, 0, 1), maxQuanta);
                    expQuanta = maxQuanta - 1;
                }
                if (expQuanta != quantaRemaining) {
                    quantaRemaining = expQuanta;
                    if (expQuanta <= 0) {
                        world.func_175698_g(pos);
                    } else {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 2);
                        world.func_175684_a(pos, (Block)this, this.tickRate);
                        world.func_175685_c(pos, (Block)this);
                    }
                }
            } else if (quantaRemaining >= this.quantaPerBlock) {
                world.func_180501_a(pos, this.func_176223_P(), 2);
            }
        }
        if (this.canDisplace((IBlockAccess)world, pos.func_177981_b(this.densityDir))) {
            this.flowIntoBlock(world, pos.func_177981_b(this.densityDir), 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, pos) || !this.isFlowingVertically((IBlockAccess)world, pos)) {
            boolean[] flowTo;
            if (world.func_180495_p(pos.func_177979_c(this.densityDir)).func_177230_c() == this) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, pos))[0]) {
                this.flowIntoBlock(world, pos.func_177982_a(-1, 0, 0), flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, pos.func_177982_a(1, 0, 0), flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, pos.func_177982_a(0, 0, -1), flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, pos.func_177982_a(0, 0, 1), flowMeta);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        if (state.func_177230_c() instanceof BlockSwampWater && ((BlockSwampWater)state.func_177230_c()).isUnderwaterBlock) {
            return state.func_185900_c((IBlockAccess)worldIn, pos).func_186670_a(pos);
        }
        return null;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        if (blockState.func_177230_c() instanceof BlockSwampWater && ((BlockSwampWater)blockState.func_177230_c()).isUnderwaterBlock) {
            return blockState.func_185900_c((IBlockAccess)worldIn, pos);
        }
        return null;
    }

    public boolean func_176209_a(IBlockState state, boolean fullHit) {
        if (state.func_177230_c() instanceof BlockSwampWater && ((BlockSwampWater)state.func_177230_c()).isUnderwaterBlock) {
            return true;
        }
        return super.func_176209_a(state, fullHit);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSwampWater && ((BlockSwampWater)state.func_177230_c()).isUnderwaterBlock) {
            return false;
        }
        return super.func_176200_f(worldIn, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{LEVEL});
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && (!this.isUnderwaterBlock || worldIn.func_180495_p(pos).func_185904_a() == Material.field_151586_h);
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        if (worldIn == null || pos == null || tintIndex != 0) {
            return -1;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                int colorMultiplier = worldIn.func_180494_b(pos.func_177982_a(dx, 0, dz)).getWaterColorMultiplier();
                r += (colorMultiplier & 0xFF0000) >> 16;
                g += (colorMultiplier & 0xFF00) >> 8;
                b += colorMultiplier & 0xFF;
            }
        }
        r /= 9;
        g /= 9;
        b /= 9;
        float depth = 0.0f;
        depth = pos.func_177956_o() > 110 ? 1.0f : (pos.func_177956_o() < 15 ? 0.0f : (float)(pos.func_177956_o() - 15) / 95.0f);
        r = (int)((float)r * depth + 19.0f * (1.0f - depth) + 0.5f);
        g = (int)((float)g * depth + 24.0f * (1.0f - depth) + 0.5f);
        b = (int)((float)b * depth + 68.0f * (1.0f - depth) + 0.5f);
        return r << 16 | g << 8 | b;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(1500) == 0) {
            if (world.func_180495_p(pos.func_177981_b(2)).func_185904_a().func_76224_d()) {
                BLParticles.FISH.spawn(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == BlockRegistry.MUD) {
                if (rand.nextInt(2) == 0) {
                    BLParticles.MOSQUITO.spawn(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
                } else {
                    BLParticles.FLY.spawn(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
                }
            }
        }
    }
}

