/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.BlockStateContainerHelper;
import thebetweenlands.common.block.terrain.BlockRoot;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockRootUnderwater
extends BlockSwampWater {
    public BlockRootUnderwater() {
        super(FluidRegistry.SWAMP_WATER, Material.field_151586_h);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.setUnderwaterBlock(true);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.setHarvestLevel("axe", 0);
    }

    protected BlockStateContainer func_180661_e() {
        return BlockStateContainerHelper.extendBlockstateContainer((ExtendedBlockState)super.func_180661_e(), new IProperty[0], new IUnlistedProperty[]{BlockRoot.POS_X, BlockRoot.POS_Y, BlockRoot.POS_Z, BlockRoot.NO_BOTTOM, BlockRoot.NO_TOP, BlockRoot.DIST_UP, BlockRoot.DIST_DOWN});
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRegistry.TANGLED_ROOT;
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess worldIn, BlockPos pos) {
        IBlockState blockState;
        IExtendedBlockState state = (IExtendedBlockState)super.getExtendedState(oldState, worldIn, pos);
        int maxLength = 32;
        int distUp = 0;
        int distDown = 0;
        boolean noTop = false;
        boolean noBottom = false;
        for (distUp = 0; distUp < 32; ++distUp) {
            blockState = worldIn.func_180495_p(pos.func_177982_a(0, 1 + distUp, 0));
            if (blockState.func_177230_c() == this || blockState.func_177230_c() == BlockRegistry.ROOT) continue;
            if (blockState.func_177230_c() != Blocks.field_150350_a && blockState.func_185914_p()) break;
            noTop = true;
            break;
        }
        for (distDown = 0; distDown < 32; ++distDown) {
            blockState = worldIn.func_180495_p(pos.func_177982_a(0, -(1 + distDown), 0));
            if (blockState.func_177230_c() == this || blockState.func_177230_c() == BlockRegistry.ROOT) continue;
            if (blockState.func_177230_c() != Blocks.field_150350_a && blockState.func_185914_p()) break;
            noBottom = true;
            break;
        }
        return state.withProperty((IUnlistedProperty)BlockRoot.POS_X, (Object)pos.func_177958_n()).withProperty((IUnlistedProperty)BlockRoot.POS_Y, (Object)pos.func_177956_o()).withProperty((IUnlistedProperty)BlockRoot.POS_Z, (Object)pos.func_177952_p()).withProperty((IUnlistedProperty)BlockRoot.DIST_UP, (Object)distUp).withProperty((IUnlistedProperty)BlockRoot.DIST_DOWN, (Object)distDown).withProperty((IUnlistedProperty)BlockRoot.NO_TOP, (Object)noTop).withProperty((IUnlistedProperty)BlockRoot.NO_BOTTOM, (Object)noBottom);
    }
}

