/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.BlockStateContainerHelper;
import thebetweenlands.common.block.property.PropertyBoolUnlisted;
import thebetweenlands.common.block.property.PropertyIntegerUnlisted;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.item.ItemBlockEnum;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockLifeCrystalStalactite
extends BlockSwampWater
implements BlockRegistry.ICustomItemBlock,
BlockRegistry.ISubtypeBlock,
BlockRegistry.IStateMappedBlock {
    public static final PropertyEnum<EnumLifeCrystalType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumLifeCrystalType.class);
    public static final PropertyBoolUnlisted NO_BOTTOM = new PropertyBoolUnlisted("no_bottom");
    public static final PropertyBoolUnlisted NO_TOP = new PropertyBoolUnlisted("no_top");
    public static final PropertyIntegerUnlisted DIST_UP = new PropertyIntegerUnlisted("dist_up");
    public static final PropertyIntegerUnlisted DIST_DOWN = new PropertyIntegerUnlisted("dist_down");
    public static final PropertyIntegerUnlisted POS_X = new PropertyIntegerUnlisted("pos_x");
    public static final PropertyIntegerUnlisted POS_Y = new PropertyIntegerUnlisted("pos_x");
    public static final PropertyIntegerUnlisted POS_Z = new PropertyIntegerUnlisted("pos_z");

    public BlockLifeCrystalStalactite(Fluid fluid, Material materialIn) {
        super(fluid, materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumLifeCrystalType.DEFAULT)));
        this.func_149711_c(2.5f);
        this.func_149752_b(10.0f);
        this.setUnderwaterBlock(true);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.setHarvestLevel("pickaxe", 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, EnumLifeCrystalType.DEFAULT.getMetadata()));
        list.add(new ItemStack((Block)this, 1, EnumLifeCrystalType.ORE.getMetadata()));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((EnumLifeCrystalType)((Object)state.func_177229_b(VARIANT))).getMetadata());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumLifeCrystalType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumLifeCrystalType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return BlockStateContainerHelper.extendBlockstateContainer((ExtendedBlockState)super.func_180661_e(), new IProperty[]{VARIANT}, new IUnlistedProperty[]{POS_X, POS_Y, POS_Z, NO_BOTTOM, NO_TOP, DIST_UP, DIST_DOWN});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumLifeCrystalType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create((Block)this, EnumLifeCrystalType.class);
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess worldIn, BlockPos pos) {
        IBlockState blockState;
        IExtendedBlockState state = (IExtendedBlockState)super.getExtendedState(oldState, worldIn, pos);
        int maxLength = 32;
        int distUp = 0;
        int distDown = 0;
        boolean noTop = false;
        boolean noBottom = false;
        for (distUp = 0; distUp < 32; ++distUp) {
            blockState = worldIn.func_180495_p(pos.func_177982_a(0, 1 + distUp, 0));
            if (blockState.func_177230_c() == this) continue;
            if (blockState.func_177230_c() != Blocks.field_150350_a && blockState.func_185914_p()) break;
            noTop = true;
            break;
        }
        for (distDown = 0; distDown < 32; ++distDown) {
            blockState = worldIn.func_180495_p(pos.func_177982_a(0, -(1 + distDown), 0));
            if (blockState.func_177230_c() == this) continue;
            if (blockState.func_177230_c() != Blocks.field_150350_a && blockState.func_185914_p()) break;
            noBottom = true;
            break;
        }
        return state.withProperty((IUnlistedProperty)POS_X, (Object)pos.func_177958_n()).withProperty((IUnlistedProperty)POS_Y, (Object)pos.func_177956_o()).withProperty((IUnlistedProperty)POS_Z, (Object)pos.func_177952_p()).withProperty((IUnlistedProperty)DIST_UP, (Object)distUp).withProperty((IUnlistedProperty)DIST_DOWN, (Object)distDown).withProperty((IUnlistedProperty)NO_TOP, (Object)noTop).withProperty((IUnlistedProperty)NO_BOTTOM, (Object)noBottom);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        super.setStateMapper(builder);
        builder.ignore(new IProperty[]{VARIANT});
    }

    @Override
    public int getSubtypeNumber() {
        return EnumLifeCrystalType.values().length;
    }

    @Override
    public String getSubtypeName(int meta) {
        return "%s_" + EnumLifeCrystalType.values()[meta].func_176610_l();
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(VARIANT) == EnumLifeCrystalType.ORE ? ItemRegistry.LIFE_CRYSTAL : null;
    }

    public static enum EnumLifeCrystalType implements IStringSerializable
    {
        DEFAULT,
        ORE;

        private final String name = this.name().toLowerCase(Locale.ENGLISH);

        public int getMetadata() {
            return this.ordinal();
        }

        public String toString() {
            return this.name;
        }

        public static EnumLifeCrystalType byMetadata(int metadata) {
            if (metadata < 0 || metadata >= EnumLifeCrystalType.values().length) {
                metadata = 0;
            }
            return EnumLifeCrystalType.values()[metadata];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

