/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockLeavesBetweenlands
extends BlockLeaves
implements BlockRegistry.IStateMappedBlock {
    private int[] decayBlockCache;

    public BlockLeavesBetweenlands() {
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this;
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this));
        return ret;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (world.field_73012_v.nextInt(160) == 0 && world.func_175623_d(pos.func_177977_b())) {
            BLParticles.WEEDWOOD_LEAF.spawn(world, (float)pos.func_177958_n() + rand.nextFloat(), pos.func_177956_o(), (float)pos.func_177952_p() + rand.nextFloat(), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withScale(1.0f + rand.nextFloat() * 1.25f));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{field_176236_b, field_176237_a});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            int distanceToLog;
            int z;
            int y;
            int x;
            int logReach = 5;
            int checkRadius = logReach + 1;
            int cacheSize = 32;
            int cacheSquared = cacheSize * cacheSize;
            int cacheHalf = cacheSize / 2;
            if (this.decayBlockCache == null) {
                this.decayBlockCache = new int[cacheSize * cacheSize * cacheSize];
            }
            if (worldIn.func_175707_a(new BlockPos((x = pos.func_177958_n()) - checkRadius, (y = pos.func_177956_o()) - checkRadius, (z = pos.func_177952_p()) - checkRadius), new BlockPos(x + checkRadius, y + checkRadius, z + checkRadius))) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int xo = -logReach; xo <= logReach; ++xo) {
                    for (int yo = -logReach; yo <= logReach; ++yo) {
                        for (int zo = -logReach; zo <= logReach; ++zo) {
                            IBlockState blockState = worldIn.func_180495_p((BlockPos)mutableBlockPos.func_181079_c(x + xo, y + yo, z + zo));
                            Block block = blockState.func_177230_c();
                            if (!block.canSustainLeaves(blockState, (IBlockAccess)worldIn, (BlockPos)mutableBlockPos.func_181079_c(x + xo, y + yo, z + zo))) {
                                if (block.isLeaves(blockState, (IBlockAccess)worldIn, (BlockPos)mutableBlockPos.func_181079_c(x + xo, y + yo, z + zo))) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = -2;
                                    continue;
                                }
                                this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = -1;
                                continue;
                            }
                            this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = 0;
                        }
                    }
                }
                for (int distancePass = 1; distancePass <= logReach; ++distancePass) {
                    for (int xo = -logReach; xo <= logReach; ++xo) {
                        for (int yo = -logReach; yo <= logReach; ++yo) {
                            for (int zo = -logReach; zo <= logReach; ++zo) {
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] != distancePass - 1) continue;
                                if (this.decayBlockCache[(xo + cacheHalf - 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf - 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf + 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf + 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf - 1) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf - 1) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf + 1) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf + 1) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + (zo + cacheHalf - 1)] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + (zo + cacheHalf - 1)] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf + 1] != -2) continue;
                                this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf + 1] = distancePass;
                            }
                        }
                    }
                }
            }
            if ((distanceToLog = this.decayBlockCache[cacheHalf * cacheSquared + cacheHalf * cacheSize + cacheHalf]) >= 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)), 4);
            } else {
                this.removeLeaves(worldIn, pos);
            }
        }
    }

    protected void removeLeaves(World world, BlockPos pos) {
        this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        world.func_175698_g(pos);
    }
}

