/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import thebetweenlands.api.block.ISickleHarvestable;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.herblore.ItemPlantDrop;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockHanger
extends Block
implements IShearable,
ISickleHarvestable {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);

    public BlockHanger() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.5f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Material material = worldIn.func_180495_p(pos.func_177984_a()).func_185904_a();
        return super.func_176196_c(worldIn, pos) && (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLog || material == Material.field_151584_j || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, worldIn, pos, blockIn);
        Material material = worldIn.func_180495_p(pos.func_177984_a()).func_185904_a();
        if (!(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLog) && material != Material.field_151584_j && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (rand.nextInt(16) == 0 && worldIn.func_175623_d(pos.func_177977_b())) {
            worldIn.func_175656_a(pos.func_177977_b(), this.func_176223_P());
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return item.func_77973_b() == ItemRegistry.SYRMORITE_SHEARS;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack(Item.func_150898_a((Block)this)));
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public List<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)ItemPlantDrop.EnumItemPlantDrop.HANGER_ITEM.create(1));
    }
}

