/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.block.BasicBlock;

public class BlockGenericOre
extends BasicBlock {
    private Random rand = new Random();
    private int minXP = 0;
    private int maxXP = 0;

    public BlockGenericOre(Material materialIn) {
        super(materialIn);
        this.setDefaultCreativeTab().setSoundType2(SoundType.field_185851_d).func_149711_c(1.5f).func_149752_b(10.0f);
    }

    public BlockGenericOre setXP(int min, int max) {
        this.minXP = min;
        this.maxXP = max;
        return this;
    }

    protected ItemStack getOreDrop(Random rand, int fortune) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    public int func_149745_a(Random random) {
        ItemStack oreDrop = this.getOreDrop(random, 0);
        return oreDrop != null ? oreDrop.field_77994_a : 0;
    }

    public int func_149679_a(int fortune, Random random) {
        ItemStack oreDrop = this.getOreDrop(random, fortune);
        return oreDrop != null ? oreDrop.field_77994_a : 0;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        ItemStack oreDrop = this.getOreDrop(rand, fortune);
        return oreDrop != null ? oreDrop.func_77973_b() : null;
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return MathHelper.func_76136_a((Random)this.rand, (int)this.minXP, (int)this.maxXP);
    }

    public int func_180651_a(IBlockState state) {
        ItemStack oreDrop = this.getOreDrop(this.rand, 0);
        return oreDrop != null ? oreDrop.func_77952_i() : 0;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double pixel = 0.0625;
        if (rand.nextInt(3) == 0) {
            for (int l = 0; l < 5; ++l) {
                double particleX = (float)pos.func_177958_n() + rand.nextFloat();
                double particleY = (float)pos.func_177956_o() + rand.nextFloat();
                double particleZ = (float)pos.func_177952_p() + rand.nextFloat();
                if (l == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                    particleY = (double)(pos.func_177956_o() + 1) + pixel;
                }
                if (l == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                    particleY = (double)pos.func_177956_o() - pixel;
                }
                if (l == 2 && !worldIn.func_180495_p(pos.func_177982_a(0, 0, 1)).func_185914_p()) {
                    particleZ = (double)(pos.func_177952_p() + 1) + pixel;
                }
                if (l == 3 && !worldIn.func_180495_p(pos.func_177982_a(0, 0, -1)).func_185914_p()) {
                    particleZ = (double)pos.func_177952_p() - pixel;
                }
                if (l == 4 && !worldIn.func_180495_p(pos.func_177982_a(1, 0, 0)).func_185914_p()) {
                    particleX = (double)(pos.func_177958_n() + 1) + pixel;
                }
                if (l == 5 && !worldIn.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_185914_p()) {
                    particleX = (double)pos.func_177958_n() - pixel;
                }
                if (!(particleX < (double)pos.func_177958_n() || particleX > (double)(pos.func_177958_n() + 1) || particleY < (double)pos.func_177956_o() || particleY > (double)(pos.func_177956_o() + 1) || particleZ < (double)pos.func_177952_p()) && !(particleZ > (double)(pos.func_177952_p() + 1))) continue;
                this.spawnParticle(worldIn, particleX, particleY, particleZ);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    public void spawnParticle(World world, double x, double y, double z) {
    }
}

