/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.block.plant.BlockStackablePlant;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class BlockSwampReed
extends BlockStackablePlant {
    public BlockSwampReed() {
        this.setMaxHeight(4);
        this.func_149647_a(null);
    }

    @Override
    protected boolean isSamePlant(IBlockState blockState) {
        return super.isSamePlant(blockState) || blockState.func_177230_c() == BlockRegistry.SWAMP_REED_UNDERWATER;
    }

    @Override
    protected boolean func_185514_i(IBlockState state) {
        return super.func_185514_i(state) || state.func_177230_c() == BlockRegistry.SWAMP_REED_UNDERWATER || SurfaceType.SAND.matches(state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRegistry.SWAMP_REED_ITEM;
    }

    @Override
    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of();
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        boolean canPlace;
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        boolean bl = canPlace = worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        if (canPlace) {
            if (this.isSamePlant(worldIn.func_180495_p(pos.func_177977_b()))) {
                return true;
            }
            BlockPos blockpos = pos.func_177977_b();
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177972_a(enumfacing));
                if (iblockstate.func_185904_a() != Material.field_151586_h) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) {
            if (this.isSamePlant(worldIn.func_180495_p(pos.func_177977_b()))) {
                return true;
            }
            BlockPos blockpos = pos.func_177977_b();
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177972_a(enumfacing));
                if (iblockstate.func_185904_a() != Material.field_151586_h) continue;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (world.field_73012_v.nextInt(65) == 0) {
            BLParticles.MOSQUITO.spawn(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }
    }
}

