/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.feature.WorldGenRubberTree;
import thebetweenlands.common.world.gen.feature.tree.WorldGenSapTree;
import thebetweenlands.common.world.gen.feature.tree.WorldGenWeedwoodTree;
import thebetweenlands.util.AdvancedStateMap;

public class BlockSaplingBetweenlands
extends BlockSapling
implements BlockRegistry.IStateMappedBlock {
    private String TREE_TYPE;

    public BlockSaplingBetweenlands(String type) {
        this.func_149647_a(BLCreativeTabs.PLANTS);
        this.func_149672_a(SoundType.field_185850_c);
        this.TREE_TYPE = type;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            this.func_176475_e(world, pos, state);
            if (rand.nextInt(7) == 0) {
                this.func_176478_d(world, pos, state, rand);
            }
        }
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == BlockRegistry.SWAMP_DIRT || state.func_177230_c() == BlockRegistry.SWAMP_GRASS || state.func_177230_c() == BlockRegistry.DEAD_GRASS || super.func_185514_i(state);
    }

    public void func_176476_e(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        WorldGenerator worldGen = null;
        switch (this.TREE_TYPE) {
            case "WEEDWOOD": {
                worldGen = new WorldGenWeedwoodTree();
                break;
            }
            case "SAP": {
                worldGen = new WorldGenSapTree();
                break;
            }
            case "RUBBER": {
                worldGen = new WorldGenRubberTree();
                break;
            }
        }
        if (worldGen == null) {
            return;
        }
        world.func_175698_g(pos);
        if (!worldGen.func_180709_b(world, rand, pos)) {
            world.func_175656_a(pos, state);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{field_176480_a});
    }
}

