/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import thebetweenlands.api.block.ISickleHarvestable;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.herblore.ItemPlantDrop;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class BlockCaveMoss
extends BlockBush
implements ISickleHarvestable,
IShearable {
    public static final PropertyBool IS_TOP = PropertyBool.func_177716_a((String)"is_top");
    public static final PropertyBool IS_BOTTOM = PropertyBool.func_177716_a((String)"is_bottom");
    public static final AxisAlignedBB CAVE_MOSS_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);

    public BlockCaveMoss() {
        super(Material.field_151585_k);
        this.func_149675_a(false);
        this.func_149711_c(0.0f);
        this.func_149647_a(BLCreativeTabs.PLANTS);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IS_TOP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)IS_BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IS_TOP, IS_BOTTOM});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean isTop = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this;
        boolean isBottom = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != this;
        return state.func_177226_a((IProperty)IS_TOP, (Comparable)Boolean.valueOf(isTop)).func_177226_a((IProperty)IS_BOTTOM, (Comparable)Boolean.valueOf(isBottom));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CAVE_MOSS_AABB;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.isValidBlock(world.func_180495_p(pos.func_177984_a())) && this.func_180671_f(world, pos, world.func_180495_p(pos));
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        return this.isValidBlock(worldIn.func_180495_p(pos.func_177984_a()));
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!this.isValidBlock(worldIn.func_180495_p(pos.func_177984_a()))) {
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(40) == 0) {
            float dripRange = 0.5f;
            float px = rand.nextFloat() - 0.5f;
            float py = rand.nextFloat();
            float pz = rand.nextFloat() - 0.5f;
            float u = Math.max(Math.abs(px), Math.abs(pz));
            px = px / u * dripRange + 0.5f;
            pz = pz / u * dripRange + 0.5f;
            BLParticles.CAVE_WATER_DRIP.spawn(worldIn, (float)pos.func_177958_n() + px, (float)pos.func_177956_o() + py, (float)pos.func_177952_p() + pz);
        }
    }

    protected boolean isValidBlock(IBlockState blockState) {
        return SurfaceType.UNDERGROUND.matches(blockState) || blockState.func_177230_c() == this;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return item.func_77973_b() == ItemRegistry.SYRMORITE_SHEARS;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack(Item.func_150898_a((Block)this)));
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public List<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)ItemPlantDrop.EnumItemPlantDrop.CAVE_MOSS_ITEM.create(1));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }
}

