/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.terrain.BlockRubberLog;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityRubberTap;
import thebetweenlands.util.TileEntityHelper;

public class BlockRubberTap
extends BlockHorizontal
implements ITileEntityProvider {
    public static final PropertyInteger AMOUNT = PropertyInteger.func_177719_a((String)"amount", (int)0, (int)15);
    protected static final AxisAlignedBB TAP_WEST_AABB = new AxisAlignedBB(0.4, 0.0, 0.15, 1.0, 1.0, 0.85);
    protected static final AxisAlignedBB TAP_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.15, 0.6, 1.0, 0.85);
    protected static final AxisAlignedBB TAP_SOUTH_AABB = new AxisAlignedBB(0.15, 0.0, 0.0, 0.85, 1.0, 0.6);
    protected static final AxisAlignedBB TAP_NORTH_AABB = new AxisAlignedBB(0.15, 0.0, 0.4, 0.85, 1.0, 1.0);
    public final int ticksPerStep;

    public BlockRubberTap(IBlockState material, int ticksPerStep) {
        super(material.func_185904_a());
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)AMOUNT, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(material.func_177230_c().func_185467_w());
        this.func_149711_c(2.0f);
        this.ticksPerStep = ticksPerStep;
        this.func_149647_a(null);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)facing);
        }
        for (EnumFacing enumfacing : field_185512_D.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : field_185512_D.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (this.checkForDrop(worldIn, pos, state)) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing oppositeFacing = facing.func_176734_d();
            if (axis.func_176720_b() || !this.canPlaceOn(worldIn, pos.func_177972_a(oppositeFacing))) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)field_185512_D))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockPos = pos.func_177972_a(facing.func_176734_d());
        boolean isHorizontal = facing.func_176740_k().func_176722_c();
        return isHorizontal && this.canPlaceOn(worldIn, blockPos);
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.func_177230_c() == BlockRegistry.LOG_RUBBER && (Boolean)state.func_177229_b((IProperty)BlockRubberLog.NATURAL) != false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, AMOUNT});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityRubberTap te = TileEntityHelper.getTileEntityThreadSafe(worldIn, pos, TileEntityRubberTap.class);
        if (te != null) {
            FluidStack drained = te.drain(1000, false);
            if (drained != null) {
                int amount = (int)((float)drained.amount / 1000.0f * 15.0f);
                state = state.func_177226_a((IProperty)AMOUNT, (Comparable)Integer.valueOf(amount));
            } else {
                state = state.func_177226_a((IProperty)AMOUNT, (Comparable)Integer.valueOf(0));
            }
        }
        return state;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRubberTap();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
            default: {
                return TAP_EAST_AABB;
            }
            case WEST: {
                return TAP_WEST_AABB;
            }
            case SOUTH: {
                return TAP_SOUTH_AABB;
            }
            case NORTH: 
        }
        return TAP_NORTH_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.func_185496_a(blockState, (IBlockAccess)worldIn, pos);
    }
}

