/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.plant.BlockPlant;
import thebetweenlands.common.block.plant.BlockPlantUnderwater;
import thebetweenlands.common.block.plant.BlockStackablePlant;
import thebetweenlands.common.block.property.PropertyBlockStateUnlisted;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityMudFlowerPot;
import thebetweenlands.util.TileEntityHelper;

public class BlockMudFlowerPot
extends BlockContainer {
    protected static final AxisAlignedBB FLOWER_POT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);
    public static final PropertyBlockStateUnlisted FLOWER = new PropertyBlockStateUnlisted("flower");
    protected Map<Item, Function<ItemStack, IBlockState>> plants = new HashMap<Item, Function<ItemStack, IBlockState>>();

    public BlockMudFlowerPot() {
        super(Material.field_151594_q);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public void registerPlant(Item item, Function<ItemStack, IBlockState> provider) {
        this.plants.put(item, provider);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_POT_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{FLOWER});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState blockState;
        state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)FLOWER, (Object)Blocks.field_150350_a.func_176223_P());
        TileEntityMudFlowerPot te = TileEntityHelper.getTileEntityThreadSafe(world, pos, TileEntityMudFlowerPot.class);
        if (te != null && te.func_184403_b() != null && (blockState = this.getPlantBlockStateFromItem(te.func_184403_b())) != null) {
            state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)FLOWER, (Object)blockState);
        }
        return state;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null) {
            TileEntityMudFlowerPot te = this.getTileEntity(worldIn, pos);
            if (te == null) {
                return false;
            }
            if (te.func_145965_a() != null) {
                return false;
            }
            if (this.getPlantBlockStateFromItem(heldItem) != null) {
                te.func_145964_a(heldItem.func_77973_b(), heldItem.func_77960_j());
                te.func_70296_d();
                worldIn.func_184138_a(pos, state, state, 3);
                playerIn.func_71029_a(StatList.field_188088_V);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --heldItem.field_77994_a;
                }
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    @Nullable
    protected IBlockState getPlantBlockStateFromItem(ItemStack itemStack) {
        if (itemStack != null) {
            Function<ItemStack, IBlockState> provider;
            Item item = itemStack.func_77973_b();
            if (item instanceof ItemBlock) {
                Block blockIn = Block.func_149634_a((Item)((ItemBlock)item));
                if (blockIn == Blocks.field_150327_N || blockIn == Blocks.field_150328_O || blockIn == Blocks.field_150434_aF || blockIn == Blocks.field_150338_P || blockIn == Blocks.field_150337_Q || blockIn == Blocks.field_150345_g || blockIn == Blocks.field_150330_I || blockIn == Blocks.field_150329_H && itemStack.func_77960_j() == BlockTallGrass.EnumType.FERN.func_177044_a() || blockIn instanceof BlockPlant && !(blockIn instanceof BlockPlantUnderwater) && !(blockIn instanceof BlockStackablePlant)) {
                    return blockIn.func_176223_P();
                }
            } else {
                if (item == ItemRegistry.BULB_CAPPED_MUSHROOM_ITEM) {
                    return BlockRegistry.BULB_CAPPED_MUSHROOM.func_176223_P();
                }
                if (item == ItemRegistry.BLACK_HAT_MUSHROOM_ITEM) {
                    return BlockRegistry.BLACK_HAT_MUSHROOM.func_176223_P();
                }
                if (item == ItemRegistry.FLAT_HEAD_MUSHROOM_ITEM) {
                    return BlockRegistry.FLAT_HEAD_MUSHROOM.func_176223_P();
                }
            }
            if ((provider = this.plants.get(item)) != null) {
                return provider.apply(itemStack);
            }
        }
        return null;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack itemstack;
        TileEntityMudFlowerPot te = this.getTileEntity(worldIn, pos);
        if (te != null && (itemstack = te.func_184403_b()) != null) {
            return itemstack;
        }
        return new ItemStack(BlockRegistry.MUD_FLOWER_POT);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityMudFlowerPot te;
        super.func_176208_a(worldIn, pos, state, player);
        if (player.field_71075_bZ.field_75098_d && (te = this.getTileEntity(worldIn, pos)) != null) {
            te.func_145964_a(null, 0);
        }
    }

    @Nullable
    private TileEntityMudFlowerPot getTileEntity(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityMudFlowerPot ? (TileEntityMudFlowerPot)tileentity : null;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityMudFlowerPot te;
        List ret = super.getDrops(world, pos, state, fortune);
        TileEntityMudFlowerPot tileEntityMudFlowerPot = te = world.func_175625_s(pos) instanceof TileEntityMudFlowerPot ? (TileEntityMudFlowerPot)world.func_175625_s(pos) : null;
        if (te != null && te.func_145965_a() != null) {
            ret.add(new ItemStack(te.func_145965_a(), 1, te.func_145966_b()));
        }
        return ret;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMudFlowerPot();
    }
}

