/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.farming;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.IFarmablePlant;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.block.farming.BlockGenericCrop;
import thebetweenlands.common.block.property.PropertyIntegerUnlisted;
import thebetweenlands.common.item.ItemBlockMeta;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityDugSoil;
import thebetweenlands.util.AdvancedStateMap;

public abstract class BlockGenericDugSoil
extends BasicBlock
implements ITileEntityProvider,
BlockRegistry.ISubtypeBlock,
BlockRegistry.IStateMappedBlock,
BlockRegistry.ICustomItemBlock {
    public static final IUnlistedProperty<Integer> TOP_NORTH_WEST_INDEX = new PropertyIntegerUnlisted("top_north_west_index");
    public static final IUnlistedProperty<Integer> TOP_NORTH_EAST_INDEX = new PropertyIntegerUnlisted("top_north_east_index");
    public static final IUnlistedProperty<Integer> TOP_SOUTH_WEST_INDEX = new PropertyIntegerUnlisted("top_south_west_index");
    public static final IUnlistedProperty<Integer> TOP_SOUTH_EAST_INDEX = new PropertyIntegerUnlisted("top_south_east_index");
    public static final PropertyBool COMPOSTED = PropertyBool.func_177716_a((String)"composted");
    public static final PropertyBool DECAYED = PropertyBool.func_177716_a((String)"decayed");
    public final boolean purified;

    public BlockGenericDugSoil(Material material) {
        this(material, false);
    }

    public BlockGenericDugSoil(Material material, boolean purified) {
        super(material);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("shovel", 0);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)COMPOSTED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAYED, (Comparable)Boolean.valueOf(false)));
        this.purified = purified;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{COMPOSTED, DECAYED}, new IUnlistedProperty[]{TOP_NORTH_WEST_INDEX, TOP_NORTH_EAST_INDEX, TOP_SOUTH_WEST_INDEX, TOP_SOUTH_EAST_INDEX});
    }

    public int func_176201_c(IBlockState state) {
        return !this.purified && (Boolean)state.func_177229_b((IProperty)DECAYED) != false ? 2 : ((Boolean)state.func_177229_b((IProperty)COMPOSTED) != false ? 1 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            default: {
                return this.func_176223_P();
            }
            case 1: {
                return this.func_176223_P().func_177226_a((IProperty)COMPOSTED, (Comparable)Boolean.valueOf(true));
            }
            case 2: 
        }
        if (this.purified) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a((IProperty)DECAYED, (Comparable)Boolean.valueOf(true));
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess worldIn, BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        boolean[] connectionArray = BlockGenericDugSoil.getConnectionArray(worldIn, pos, EnumFacing.UP, (Predicate<IBlockState>)((Predicate)s -> s.func_177230_c() instanceof BlockGenericDugSoil));
        int[] quadrantIndices = BlockGenericDugSoil.getQuadrantIndices(connectionArray);
        state = state.withProperty(TOP_NORTH_WEST_INDEX, (Object)quadrantIndices[0]);
        state = state.withProperty(TOP_NORTH_EAST_INDEX, (Object)quadrantIndices[1]);
        state = state.withProperty(TOP_SOUTH_WEST_INDEX, (Object)quadrantIndices[2]);
        state = state.withProperty(TOP_SOUTH_EAST_INDEX, (Object)quadrantIndices[3]);
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    private static int getIndex(int x, int y, int width) {
        return x % width + y * width;
    }

    private static int[] getQuadrantIndices(boolean[] connectionArray) {
        int tls = 0;
        int trs = 0;
        int bls = 0;
        int brs = 0;
        for (int xo = 0; xo <= 2; ++xo) {
            for (int zo = 0; zo <= 2; ++zo) {
                boolean currentNeighbourState = connectionArray[BlockGenericDugSoil.getIndex(xo, zo, 3)];
                if (xo != 1 && zo == 1 || xo == 1 && zo != 1) {
                    if (!currentNeighbourState) continue;
                    if (xo == 0) {
                        if (!connectionArray[BlockGenericDugSoil.getIndex(1, 2, 3)]) {
                            bls = 1;
                        }
                        if (connectionArray[BlockGenericDugSoil.getIndex(1, 0, 3)]) continue;
                        tls = 1;
                        continue;
                    }
                    if (xo == 2) {
                        if (!connectionArray[BlockGenericDugSoil.getIndex(1, 2, 3)]) {
                            brs = 1;
                        }
                        if (connectionArray[BlockGenericDugSoil.getIndex(1, 0, 3)]) continue;
                        trs = 1;
                        continue;
                    }
                    if (zo == 0) {
                        if (!connectionArray[BlockGenericDugSoil.getIndex(0, 1, 3)]) {
                            tls = 2;
                        }
                        if (connectionArray[BlockGenericDugSoil.getIndex(2, 1, 3)]) continue;
                        trs = 2;
                        continue;
                    }
                    if (zo != 2) continue;
                    if (!connectionArray[BlockGenericDugSoil.getIndex(0, 1, 3)]) {
                        bls = 2;
                    }
                    if (connectionArray[BlockGenericDugSoil.getIndex(2, 1, 3)]) continue;
                    brs = 2;
                    continue;
                }
                if (xo == 1 || zo == 1 || !connectionArray[BlockGenericDugSoil.getIndex(xo, 1, 3)] || !connectionArray[BlockGenericDugSoil.getIndex(1, zo, 3)]) continue;
                int segment = currentNeighbourState ? 3 : 4;
                if (xo == 2 && zo == 0) {
                    trs = segment;
                    continue;
                }
                if (xo == 2 && zo == 2) {
                    brs = segment;
                    continue;
                }
                if (xo == 0 && zo == 2) {
                    bls = segment;
                    continue;
                }
                tls = segment;
            }
        }
        return new int[]{tls, trs, bls, brs};
    }

    public static boolean[] getConnectionArray(IBlockAccess blockAccess, BlockPos pos, EnumFacing dir, Predicate<IBlockState> matcher) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        boolean xp = true;
        boolean yp = true;
        boolean xr = false;
        boolean yr = false;
        boolean zr = false;
        boolean[] connectionArray = new boolean[9];
        switch (dir) {
            case DOWN: {
                xp = false;
            }
            case UP: {
                xr = true;
                zr = true;
                break;
            }
            case NORTH: {
                yp = false;
            }
            case SOUTH: {
                xr = true;
                yr = true;
                break;
            }
            case EAST: {
                xp = false;
            }
            case WEST: {
                zr = true;
                yr = true;
                break;
            }
            default: {
                return connectionArray;
            }
        }
        for (int xo = xr ? -1 : 0; xo <= (xr ? 1 : 0); ++xo) {
            for (int yo = yr ? -1 : 0; yo <= (yr ? 1 : 0); ++yo) {
                for (int zo = zr ? -1 : 0; zo <= (zr ? 1 : 0); ++zo) {
                    int mx = (xr ? xo : yo) + 1;
                    int my = (zr ? zo : (xr ? yo : zo)) + 1;
                    int blockIndex = BlockGenericDugSoil.getIndex(xp ? mx : 2 - mx, yp ? my : 2 - my, 3);
                    connectionArray[blockIndex] = matcher.apply((Object)blockAccess.func_180495_p((BlockPos)checkPos.func_181079_c(x + xo, y + yo, z + zo)));
                }
            }
        }
        return connectionArray;
    }

    @Override
    public int getSubtypeNumber() {
        return this.purified ? 2 : 3;
    }

    @Override
    public String getSubtypeName(int meta) {
        switch (meta) {
            default: {
                return "%s";
            }
            case 1: {
                return "%s_composted";
            }
            case 2: 
        }
        return "%s_decayed";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
        if (!this.purified) {
            list.add(new ItemStack((Block)this, 1, 2));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{COMPOSTED}).ignore(new IProperty[]{DECAYED}).withPropertySuffix((IProperty<Boolean>)COMPOSTED, null, "composted").withPropertySuffixExclusions(map -> {
            if (((Boolean)map.getValue(COMPOSTED)).booleanValue() && ((Boolean)map.getValue(DECAYED)).booleanValue()) {
                return ImmutableList.of((Object)COMPOSTED, (Object)DECAYED);
            }
            return ImmutableList.of();
        });
        if (!this.purified) {
            builder.withPropertySuffixTrue((IProperty<Boolean>)DECAYED, "decayed");
        }
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemBlockMeta(this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDugSoil) {
            TileEntityDugSoil te = (TileEntityDugSoil)tile;
            if (((Boolean)state.func_177229_b((IProperty)COMPOSTED)).booleanValue()) {
                te.setCompost(30);
            }
            if (((Boolean)state.func_177229_b((IProperty)DECAYED)).booleanValue()) {
                te.setDecay(20);
                te.setCompost(30);
            }
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDugSoil();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntityDugSoil te;
        if (!world.field_72995_K && (te = BlockGenericDugSoil.getTile(world, pos)) != null) {
            IFarmablePlant plant;
            IBlockState stateUp;
            if (!this.purified && te.isComposted() && !te.isFullyDecayed() && rand.nextFloat() <= this.getDecayChance(world, pos, state, rand)) {
                te.setDecay(te.getDecay() + 1);
            }
            if (te.isComposted() && (stateUp = world.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof IFarmablePlant && (plant = (IFarmablePlant)stateUp.func_177230_c()).isFarmable(world, pos.func_177984_a(), stateUp)) {
                BlockPos offsetPos = pos.func_177984_a();
                switch (rand.nextInt(4)) {
                    case 0: {
                        offsetPos = offsetPos.func_177978_c();
                        break;
                    }
                    case 1: {
                        offsetPos = offsetPos.func_177968_d();
                        break;
                    }
                    case 2: {
                        offsetPos = offsetPos.func_177974_f();
                        break;
                    }
                    case 3: {
                        offsetPos = offsetPos.func_177976_e();
                    }
                }
                if (plant.canSpreadTo(world, pos.func_177984_a(), stateUp, offsetPos, rand)) {
                    plant.spreadTo(world, pos.func_177984_a(), stateUp, offsetPos, rand);
                    te.setCompost(Math.max(te.getCompost() - plant.getCompostCost(world, pos.func_177984_a(), stateUp, rand), 0));
                }
            }
            if (te.isFullyDecayed()) {
                for (int i = 0; i < 1 + rand.nextInt(6); ++i) {
                    IFarmablePlant plant2;
                    BlockPos offsetPos = pos.func_177984_a();
                    switch (rand.nextInt(5)) {
                        case 0: {
                            offsetPos = offsetPos.func_177978_c();
                            break;
                        }
                        case 1: {
                            offsetPos = offsetPos.func_177968_d();
                            break;
                        }
                        case 2: {
                            offsetPos = offsetPos.func_177974_f();
                            break;
                        }
                        case 3: {
                            offsetPos = offsetPos.func_177976_e();
                        }
                    }
                    IBlockState stateOffset = world.func_180495_p(offsetPos);
                    if (!(stateOffset.func_177230_c() instanceof IFarmablePlant) || !(plant2 = (IFarmablePlant)stateOffset.func_177230_c()).isFarmable(world, offsetPos, stateOffset)) continue;
                    plant2.decayPlant(world, offsetPos, stateOffset, rand);
                }
                if (rand.nextInt(20) == 0) {
                    for (int xo = -1; xo <= 1; ++xo) {
                        for (int zo = -1; zo <= 1; ++zo) {
                            TileEntityDugSoil offsetTe;
                            BlockPos offset;
                            IBlockState offsetState;
                            if (xo == 0 && zo == 0 || zo != 0 && xo != 0 || rand.nextInt(3) != 0 || !((offsetState = world.func_180495_p(offset = pos.func_177982_a(xo, 0, zo))).func_177230_c() instanceof BlockGenericDugSoil)) continue;
                            BlockGenericDugSoil dugDirt = (BlockGenericDugSoil)offsetState.func_177230_c();
                            if (dugDirt.purified || (offsetTe = BlockGenericDugSoil.getTile(world, offset)) == null || offsetTe.isFullyDecayed() || !offsetTe.isComposted()) continue;
                            offsetTe.setDecay(offsetTe.getDecay() + 1);
                        }
                    }
                }
            }
        }
    }

    protected float getDecayChance(World world, BlockPos pos, IBlockState state, Random rand) {
        return 0.25f;
    }

    public static TileEntityDugSoil getTile(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityDugSoil) {
            return (TileEntityDugSoil)te;
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityDugSoil te = BlockGenericDugSoil.getTile(world, pos);
        if (te != null && te.getCompost() == 0 && heldItem != null && ItemMisc.EnumItemMisc.COMPOST.isItemOf(heldItem)) {
            if (!world.field_72995_K) {
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ), SoundEvents.field_187577_bU, SoundCategory.PLAYERS, 1.0f, 0.5f + world.field_73012_v.nextFloat() * 0.5f);
                te.setCompost(30);
                if (!player.func_184812_l_()) {
                    --heldItem.field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        block15: {
            block14: {
                if (!((Boolean)stateIn.func_177229_b((IProperty)DECAYED)).booleanValue()) break block14;
                BLParticles.DIRT_DECAY.spawn(worldIn, (float)pos.func_177958_n() + rand.nextFloat(), (float)pos.func_177956_o() + 1.0f, (float)pos.func_177952_p() + rand.nextFloat());
                for (int i = 0; i < 5; ++i) {
                    BlockPos offsetPos = pos.func_177984_a();
                    switch (i) {
                        case 0: {
                            offsetPos = offsetPos.func_177978_c();
                            break;
                        }
                        case 1: {
                            offsetPos = offsetPos.func_177968_d();
                            break;
                        }
                        case 2: {
                            offsetPos = offsetPos.func_177974_f();
                            break;
                        }
                        case 3: {
                            offsetPos = offsetPos.func_177976_e();
                        }
                    }
                    IBlockState stateOffset = worldIn.func_180495_p(offsetPos);
                    if (!(stateOffset.func_177230_c() instanceof IFarmablePlant) || !((IFarmablePlant)stateOffset.func_177230_c()).isFarmable(worldIn, offsetPos, stateOffset)) continue;
                    BLParticles.DIRT_DECAY.spawn(worldIn, (float)offsetPos.func_177958_n() + rand.nextFloat(), offsetPos.func_177956_o(), (float)offsetPos.func_177952_p() + rand.nextFloat());
                }
                break block15;
            }
            TileEntityDugSoil te = BlockGenericDugSoil.getTile(worldIn, pos);
            if (te.getDecay() < 11 || rand.nextInt(Math.max(120 - (te.getDecay() - 11) * 14, 2)) != 0) break block15;
            BLParticles.DIRT_DECAY.spawn(worldIn, (float)pos.func_177958_n() + rand.nextFloat(), (float)pos.func_177956_o() + 1.0f, (float)pos.func_177952_p() + rand.nextFloat());
            for (int i = 0; i < 5; ++i) {
                BlockPos offsetPos = pos.func_177984_a();
                switch (i) {
                    case 0: {
                        offsetPos = offsetPos.func_177978_c();
                        break;
                    }
                    case 1: {
                        offsetPos = offsetPos.func_177968_d();
                        break;
                    }
                    case 2: {
                        offsetPos = offsetPos.func_177974_f();
                        break;
                    }
                    case 3: {
                        offsetPos = offsetPos.func_177976_e();
                    }
                }
                IBlockState stateOffset = worldIn.func_180495_p(offsetPos);
                if (!(stateOffset.func_177230_c() instanceof IFarmablePlant) || !((IFarmablePlant)stateOffset.func_177230_c()).isFarmable(worldIn, offsetPos, stateOffset)) continue;
                BLParticles.DIRT_DECAY.spawn(worldIn, (float)offsetPos.func_177958_n() + rand.nextFloat(), offsetPos.func_177956_o(), (float)offsetPos.func_177952_p() + rand.nextFloat());
            }
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        boolean isSoilSuitable;
        if (super.canSustainPlant(state, world, pos, direction, plantable)) {
            return true;
        }
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        boolean bl = isSoilSuitable = direction == EnumFacing.UP && ((Boolean)state.func_177229_b((IProperty)DECAYED) != false || (Boolean)state.func_177229_b((IProperty)COMPOSTED) != false);
        if (!isSoilSuitable) {
            return false;
        }
        switch (plantType) {
            case Crop: {
                return true;
            }
        }
        return false;
    }

    public boolean isFertile(World world, BlockPos pos) {
        return true;
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        TileEntityDugSoil te;
        IBlockState stateDown;
        if (!event.getWorld().field_72995_K && (stateDown = event.getWorld().func_180495_p(event.getPos().func_177977_b())).func_177230_c() instanceof BlockGenericDugSoil && !(event.getState().func_177230_c() instanceof BlockGenericCrop) && event.getState().func_177230_c() instanceof IPlantable && (te = BlockGenericDugSoil.getTile(event.getWorld(), event.getPos().func_177977_b())) != null) {
            te.setCompost(Math.max(te.getCompost() - 10, 0));
        }
    }

    @SubscribeEvent
    public static void onHarvestBlock(BlockEvent.HarvestDropsEvent event) {
        IBlockState stateDown;
        if (!event.getWorld().field_72995_K && (stateDown = event.getWorld().func_180495_p(event.getPos().func_177977_b())).func_177230_c() instanceof BlockGenericDugSoil && !(event.getState().func_177230_c() instanceof BlockGenericCrop) && event.getState().func_177230_c() instanceof IPlantable && ((Boolean)stateDown.func_177229_b((IProperty)DECAYED)).booleanValue()) {
            Iterator it = event.getDrops().iterator();
            boolean removeSeeds = false;
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                if (stack == null) continue;
                if (!removeSeeds && stack.func_77973_b() instanceof ItemSeeds) {
                    removeSeeds = true;
                    continue;
                }
                it.remove();
            }
        }
    }

    @SubscribeEvent
    public static void onCropGrow(BlockEvent.CropGrowEvent.Pre event) {
        IBlockState stateDown;
        if (!event.getWorld().field_72995_K && (stateDown = event.getWorld().func_180495_p(event.getPos().func_177977_b())).func_177230_c() instanceof BlockGenericDugSoil && !(event.getState().func_177230_c() instanceof BlockGenericCrop) && event.getState().func_177230_c() instanceof IPlantable && ((Boolean)stateDown.func_177229_b((IProperty)DECAYED)).booleanValue()) {
            event.setResult(Event.Result.DENY);
        }
    }
}

