/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.farming;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.farming.BlockGenericCrop;
import thebetweenlands.common.entity.mobs.EntitySporeling;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockFungusCrop
extends BlockGenericCrop
implements BlockRegistry.ICustomItemBlock {
    public BlockFungusCrop() {
        this.func_149647_a(null);
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (this.isDecayed((IBlockAccess)worldIn, pos) && !worldIn.field_72995_K && (Integer)state.func_177229_b((IProperty)AGE) >= 15 && rand.nextInt(6) == 0) {
            EntitySporeling sporeling = new EntitySporeling(worldIn);
            sporeling.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
            worldIn.func_72838_d((Entity)sporeling);
            worldIn.func_175698_g(pos);
            this.consumeCompost(worldIn, pos, 5);
        }
    }

    @Override
    protected float getGrowthChance(World world, BlockPos pos, IBlockState state, Random rand) {
        return 0.9f;
    }

    @Override
    public int getCropDrops(IBlockAccess world, BlockPos pos, Random rand, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 15) {
            return 1 + (fortune > 0 ? rand.nextInt(1 + fortune) : 0);
        }
        return 0;
    }

    @Override
    public ItemStack getSeedDrop(IBlockAccess world, BlockPos pos, Random rand) {
        return new ItemStack(ItemRegistry.SPORES);
    }

    @Override
    public ItemStack getCropDrop(IBlockAccess world, BlockPos pos, Random rand) {
        return this.isDecayed(world, pos) ? null : new ItemStack(ItemRegistry.YELLOW_DOTTED_FUNGUS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Item getRenderedItem() {
        return ItemRegistry.SPORES;
    }
}

