/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.farming;

import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.block.farming.BlockGenericDugSoil;
import thebetweenlands.common.block.terrain.BlockSwampGrass;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityDugSoil;

public class BlockDugGrass
extends BlockGenericDugSoil
implements ITintedBlock {
    public BlockDugGrass(boolean purified) {
        super(Material.field_151577_b, purified);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (!world.field_72995_K) {
            TileEntityDugSoil te = BlockDugGrass.getTile(world, pos);
            if (te != null) {
                if (!te.isComposted() && rand.nextInt(20) == 0) {
                    if (this.purified) {
                        world.func_175656_a(pos, BlockRegistry.DUG_PURIFIED_SWAMP_GRASS.func_176223_P());
                    } else {
                        world.func_175656_a(pos, BlockRegistry.SWAMP_GRASS.func_176223_P());
                    }
                } else if (world.func_180495_p(pos.func_177984_a()).getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) {
                    int prevCompost = te.getCompost();
                    int prevDecay = te.getDecay();
                    world.func_175656_a(pos, BlockRegistry.DUG_SWAMP_DIRT.func_176223_P());
                    TileEntityDugSoil newTe = BlockDugGrass.getTile(world, pos);
                    if (newTe != null) {
                        newTe.setCompost(prevCompost);
                        newTe.setDecay(prevDecay);
                    }
                }
            }
            BlockSwampGrass.updateGrass(world, pos, rand);
        }
    }
}

