/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.tile.TileEntityPurifier;

public class BlockPurifier
extends BasicBlock
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockPurifier() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149663_c("thebetweenlands.purifier");
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175625_s(pos) instanceof TileEntityPurifier) {
            TileEntityPurifier tile = (TileEntityPurifier)world.func_175625_s(pos);
            if (player.func_70093_af()) {
                return false;
            }
            if (heldItem != null && heldItem.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                int toFill;
                FluidRegistry.FluidMultipleBlocks fluid = FluidRegistry.SWAMP_WATER;
                IFluidHandler handler = (IFluidHandler)heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                FluidStack bucketFluid = handler.drain(new FluidStack((Fluid)fluid, 1000), false);
                if (bucketFluid != null && (toFill = tile.fill(new FluidStack((Fluid)fluid, 1000), false)) > 0) {
                    ItemStack prevItem = heldItem.func_77946_l();
                    tile.fill(handler.drain(new FluidStack((Fluid)fluid, toFill), true), true);
                    if (player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, prevItem);
                    }
                    return true;
                }
            }
            if (tile != null) {
                player.openGui((Object)TheBetweenlands.INSTANCE, 7, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityPurifier) {
            TileEntityPurifier tile = (TileEntityPurifier)world.func_175625_s(pos);
            if (tile == null) {
                return 0;
            }
            return tile.lightOn ? 13 : 0;
        }
        return 0;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntityPurifier tile;
        if (world.func_175625_s(pos) instanceof TileEntityPurifier && (tile = (TileEntityPurifier)world.func_175625_s(pos)).isPurifying() && tile.lightOn) {
            float x = (float)pos.func_177958_n() + 0.5f;
            float y = (float)pos.func_177956_o() + rand.nextFloat() * 6.0f / 16.0f;
            float z = (float)pos.func_177952_p() + 0.5f;
            float fixedOffset = 0.25f;
            float randomOffset = rand.nextFloat() * 0.6f - 0.3f;
            BLParticles.PURIFIER_STEAM.spawn(world, x - fixedOffset, (double)y + 0.5, z + randomOffset);
            world.func_175688_a(EnumParticleTypes.FLAME, (double)(x - fixedOffset), (double)y, (double)(z + randomOffset), 0.0, 0.0, 0.0, new int[0]);
            BLParticles.PURIFIER_STEAM.spawn(world, x + fixedOffset, (double)y + 0.5, z + randomOffset);
            world.func_175688_a(EnumParticleTypes.FLAME, (double)(x + fixedOffset), (double)y, (double)(z + randomOffset), 0.0, 0.0, 0.0, new int[0]);
            BLParticles.PURIFIER_STEAM.spawn(world, x + randomOffset, y, z - fixedOffset);
            world.func_175688_a(EnumParticleTypes.FLAME, (double)(x + randomOffset), (double)y, (double)(z - fixedOffset), 0.0, 0.0, 0.0, new int[0]);
            BLParticles.PURIFIER_STEAM.spawn(world, x + randomOffset, (double)y + 0.5, z + fixedOffset);
            world.func_175688_a(EnumParticleTypes.FLAME, (double)(x + randomOffset), (double)y, (double)(z + fixedOffset), 0.0, 0.0, 0.0, new int[0]);
            if (world.func_175623_d(pos.func_177984_a())) {
                BLParticles.BUBBLE_PURIFIER.spawn(world, x, y + 1.0f, z);
            }
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPurifier();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }
}

